/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.client.api.ClientConfiguration;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.HttpClient;
import org.apache.pulsar.client.impl.LookupService;
import org.apache.pulsar.client.util.FutureUtil;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpLookupService
implements LookupService {
    private final HttpClient httpClient;
    private final boolean useTls;
    private static final String BasePath = "lookup/v2/destination/";
    private static final Logger log = LoggerFactory.getLogger(HttpLookupService.class);

    public HttpLookupService(String serviceUrl, ClientConfiguration conf, EventLoopGroup eventLoopGroup) throws PulsarClientException {
        this.httpClient = new HttpClient(serviceUrl, conf.getAuthentication(), eventLoopGroup, conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath());
        this.useTls = conf.isUseTls();
    }

    @Override
    public CompletableFuture<Pair<InetSocketAddress, InetSocketAddress>> getBroker(DestinationName destination) {
        return this.httpClient.get(BasePath + destination.getLookupName(), LookupData.class).thenCompose(lookupData -> {
            URI uri = null;
            try {
                if (this.useTls) {
                    uri = new URI(lookupData.getBrokerUrlTls());
                } else {
                    String serviceUrl = lookupData.getBrokerUrl();
                    if (serviceUrl == null) {
                        serviceUrl = lookupData.getNativeUrl();
                    }
                    uri = new URI(serviceUrl);
                }
                InetSocketAddress brokerAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
                return CompletableFuture.completedFuture(Pair.of((Object)brokerAddress, (Object)brokerAddress));
            }
            catch (Exception e) {
                log.warn("[{}] Lookup Failed due to invalid url {}, {}", new Object[]{destination, uri, e.getMessage()});
                return FutureUtil.failedFuture(e);
            }
        });
    }

    @Override
    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(DestinationName destination) {
        return this.httpClient.get(String.format("admin/%s/partitions", destination.getLookupName()), PartitionedTopicMetadata.class);
    }

    @Override
    public String getServiceUrl() {
        return this.httpClient.url.toString();
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }
}

