/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageBuilder;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;

public class MessageBuilderImpl
implements MessageBuilder {
    private final PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
    private ByteBuffer content;

    @Override
    public Message build() {
        return MessageImpl.create(this.msgMetadataBuilder, this.content);
    }

    @Override
    public MessageBuilder setContent(byte[] data) {
        this.setContent(data, 0, data.length);
        return this;
    }

    @Override
    public MessageBuilder setContent(byte[] data, int offet, int length) {
        this.content = ByteBuffer.wrap(data, offet, length);
        return this;
    }

    @Override
    public MessageBuilder setContent(ByteBuffer buf) {
        this.content = buf.duplicate();
        return this;
    }

    @Override
    public MessageBuilder setProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return this;
    }

    @Override
    public MessageBuilder setProperty(String name, String value) {
        this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(name).setValue(value).build());
        return this;
    }

    @Override
    public MessageBuilder setKey(String key) {
        this.msgMetadataBuilder.setPartitionKey(key);
        return this;
    }

    @Override
    public MessageBuilder setEventTime(long timestamp) {
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (String)"Invalid timestamp : '%s'", (Object[])new Object[]{timestamp});
        this.msgMetadataBuilder.setEventTime(timestamp);
        return this;
    }

    @Override
    public MessageBuilder setSequenceId(long sequenceId) {
        Preconditions.checkArgument((sequenceId >= 0L ? 1 : 0) != 0);
        this.msgMetadataBuilder.setSequenceId(sequenceId);
        return this;
    }

    @Override
    public MessageBuilder setReplicationClusters(List<String> clusters) {
        Preconditions.checkNotNull(clusters);
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addAllReplicateTo(clusters);
        return this;
    }

    @Override
    public MessageBuilder disableReplication() {
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addReplicateTo("__local__");
        return this;
    }
}

