/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.proto.PulsarApi;

public class MessageImpl
implements Message {
    private PulsarApi.MessageMetadata.Builder msgMetadataBuilder;
    private MessageId messageId;
    private ClientCnx cnx;
    private ByteBuf payload;
    private transient Map<String, String> properties;
    private Recycler.Handle recyclerHandle;
    private static final Recycler<MessageImpl> RECYCLER = new Recycler<MessageImpl>(){

        protected MessageImpl newObject(Recycler.Handle handle) {
            return new MessageImpl(handle);
        }
    };

    static MessageImpl create(PulsarApi.MessageMetadata.Builder msgMetadataBuilder, ByteBuffer payload) {
        MessageImpl msg = (MessageImpl)RECYCLER.get();
        msg.msgMetadataBuilder = msgMetadataBuilder;
        msg.messageId = null;
        msg.cnx = null;
        msg.payload = Unpooled.wrappedBuffer((ByteBuffer)payload);
        msg.properties = Collections.emptyMap();
        return msg;
    }

    MessageImpl(PulsarApi.MessageIdData messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, int partitionIndex, ClientCnx cnx) {
        this.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder((PulsarApi.MessageMetadata)msgMetadata);
        this.messageId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), partitionIndex);
        this.cnx = cnx;
        this.payload = Unpooled.copiedBuffer((ByteBuf)payload);
        if (msgMetadata.getPropertiesCount() > 0) {
            TreeMap properties = Maps.newTreeMap();
            for (PulsarApi.KeyValue entry : msgMetadata.getPropertiesList()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            this.properties = Collections.unmodifiableMap(properties);
        } else {
            this.properties = Collections.emptyMap();
        }
    }

    MessageImpl(BatchMessageIdImpl batchMessageIdImpl, PulsarApi.MessageMetadata msgMetadata, PulsarApi.SingleMessageMetadata singleMessageMetadata, ByteBuf payload, ClientCnx cnx) {
        this.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder((PulsarApi.MessageMetadata)msgMetadata);
        this.messageId = batchMessageIdImpl;
        this.cnx = cnx;
        this.payload = Unpooled.copiedBuffer((ByteBuf)payload);
        if (singleMessageMetadata.getPropertiesCount() > 0) {
            TreeMap properties = Maps.newTreeMap();
            for (PulsarApi.KeyValue entry : singleMessageMetadata.getPropertiesList()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            this.properties = Collections.unmodifiableMap(properties);
        } else {
            this.properties = Collections.emptyMap();
        }
    }

    public MessageImpl(String msgId, Map<String, String> properties, byte[] payload) {
        this(msgId, properties, Unpooled.wrappedBuffer((byte[])payload));
    }

    public MessageImpl(String msgId, Map<String, String> properties, ByteBuf payload) {
        String[] data = msgId.split(":");
        long ledgerId = Long.parseLong(data[0]);
        long entryId = Long.parseLong(data[1]);
        this.messageId = data.length == 3 ? new BatchMessageIdImpl(ledgerId, entryId, -1, Integer.parseInt(data[2])) : new MessageIdImpl(ledgerId, entryId, -1);
        this.cnx = null;
        this.payload = payload;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public static MessageImpl deserialize(ByteBuf headersAndPayload) throws IOException {
        MessageImpl msg = (MessageImpl)RECYCLER.get();
        PulsarApi.MessageMetadata msgMetadata = Commands.parseMessageMetadata((ByteBuf)headersAndPayload);
        msg.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder((PulsarApi.MessageMetadata)msgMetadata);
        msgMetadata.recycle();
        msg.payload = headersAndPayload;
        msg.messageId = null;
        msg.cnx = null;
        msg.properties = Collections.emptyMap();
        return msg;
    }

    public void setReplicatedFrom(String cluster) {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        this.msgMetadataBuilder.setReplicatedFrom(cluster);
    }

    public boolean isReplicated() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasReplicatedFrom();
    }

    public String getReplicatedFrom() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicatedFrom();
    }

    @Override
    public long getPublishTime() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPublishTime();
    }

    @Override
    public long getEventTime() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasEventTime()) {
            return this.msgMetadataBuilder.getEventTime();
        }
        return 0L;
    }

    public boolean isExpired(int messageTTLInSeconds) {
        return messageTTLInSeconds != 0 && System.currentTimeMillis() > this.getPublishTime() + TimeUnit.SECONDS.toMillis(messageTTLInSeconds);
    }

    @Override
    public byte[] getData() {
        if (this.payload.arrayOffset() == 0 && this.payload.capacity() == this.payload.array().length) {
            return this.payload.array();
        }
        byte[] data = new byte[this.payload.readableBytes()];
        this.payload.readBytes(data);
        return data;
    }

    ByteBuf getDataBuffer() {
        return this.payload;
    }

    @Override
    public MessageId getMessageId() {
        Preconditions.checkNotNull((Object)this.messageId, (Object)"Cannot get the message id of a message that was not received");
        return this.messageId;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    PulsarApi.MessageMetadata.Builder getMessageBuilder() {
        return this.msgMetadataBuilder;
    }

    @Override
    public boolean hasKey() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasPartitionKey();
    }

    @Override
    public String getKey() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPartitionKey();
    }

    public ClientCnx getCnx() {
        return this.cnx;
    }

    public void recycle() {
        this.msgMetadataBuilder = null;
        this.messageId = null;
        this.payload = null;
        this.properties = null;
        if (this.recyclerHandle != null) {
            RECYCLER.recycle((Object)this, this.recyclerHandle);
        }
    }

    private MessageImpl(Recycler.Handle recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public boolean hasReplicateTo() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicateToCount() > 0;
    }

    public List<String> getReplicateTo() {
        Preconditions.checkNotNull((Object)this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicateToList();
    }

    void setMessageId(MessageIdImpl messageId) {
        this.messageId = messageId;
    }
}

