/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerConfiguration;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderConfiguration;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;

public class ReaderImpl
implements Reader {
    private final ConsumerImpl consumer;

    public ReaderImpl(PulsarClientImpl client, String topic, MessageId startMessageId, ReaderConfiguration readerConfiguration, ExecutorService listenerExecutor, CompletableFuture<Consumer> consumerFuture) {
        String subscription = "reader-" + DigestUtils.sha1Hex((String)UUID.randomUUID().toString()).substring(0, 10);
        ConsumerConfiguration consumerConfiguration = new ConsumerConfiguration();
        consumerConfiguration.setSubscriptionType(SubscriptionType.Exclusive);
        consumerConfiguration.setReceiverQueueSize(readerConfiguration.getReceiverQueueSize());
        if (readerConfiguration.getReaderName() != null) {
            consumerConfiguration.setConsumerName(readerConfiguration.getReaderName());
        }
        if (readerConfiguration.getReaderListener() != null) {
            final ReaderListener readerListener = readerConfiguration.getReaderListener();
            consumerConfiguration.setMessageListener(new MessageListener(){
                private static final long serialVersionUID = 1L;

                @Override
                public void received(Consumer consumer, Message msg) {
                    readerListener.received(ReaderImpl.this, msg);
                    consumer.acknowledgeCumulativeAsync(msg);
                }

                @Override
                public void reachedEndOfTopic(Consumer consumer) {
                    readerListener.reachedEndOfTopic(ReaderImpl.this);
                }
            });
        }
        this.consumer = new ConsumerImpl(client, topic, subscription, consumerConfiguration, listenerExecutor, -1, consumerFuture, ConsumerImpl.SubscriptionMode.NonDurable, startMessageId);
    }

    @Override
    public String getTopic() {
        return this.consumer.getTopic();
    }

    public ConsumerImpl getConsumer() {
        return this.consumer;
    }

    @Override
    public boolean hasReachedEndOfTopic() {
        return this.consumer.hasReachedEndOfTopic();
    }

    @Override
    public Message readNext() throws PulsarClientException {
        Message msg = this.consumer.receive();
        this.consumer.acknowledgeCumulativeAsync(msg);
        return msg;
    }

    @Override
    public Message readNext(int timeout, TimeUnit unit) throws PulsarClientException {
        Message msg = this.consumer.receive(timeout, unit);
        if (msg != null) {
            this.consumer.acknowledgeCumulativeAsync(msg);
        }
        return msg;
    }

    @Override
    public CompletableFuture<Message> readNextAsync() {
        return this.consumer.receiveAsync().thenApply(msg -> {
            this.consumer.acknowledgeCumulativeAsync((Message)msg);
            return msg;
        });
    }

    @Override
    public void close() throws IOException {
        this.consumer.close();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.consumer.closeAsync();
    }
}

