/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerConfiguration;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.HandlerBase;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.client.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.collect.Queues;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;

public abstract class ConsumerBase
extends HandlerBase
implements Consumer {
    protected final String subscription;
    protected final ConsumerConfiguration conf;
    protected final String consumerName;
    protected final CompletableFuture<Consumer> subscribeFuture;
    protected final MessageListener listener;
    protected final ExecutorService listenerExecutor;
    final BlockingQueue<Message> incomingMessages;
    protected final ConcurrentLinkedQueue<CompletableFuture<Message>> pendingReceives;
    protected final int maxReceiverQueueSize;

    protected ConsumerBase(PulsarClientImpl client, String topic, String subscription, ConsumerConfiguration conf, int receiverQueueSize, ExecutorService listenerExecutor, CompletableFuture<Consumer> subscribeFuture) {
        super(client, topic, new Backoff(100L, TimeUnit.MILLISECONDS, 60L, TimeUnit.SECONDS, 0L, TimeUnit.MILLISECONDS));
        this.maxReceiverQueueSize = receiverQueueSize;
        this.subscription = subscription;
        this.conf = conf;
        this.consumerName = conf.getConsumerName() == null ? ConsumerName.generateRandomName() : conf.getConsumerName();
        this.subscribeFuture = subscribeFuture;
        this.listener = conf.getMessageListener();
        this.incomingMessages = receiverQueueSize <= 1 ? Queues.newArrayBlockingQueue(1) : new GrowableArrayBlockingQueue<Message>();
        this.listenerExecutor = listenerExecutor;
        this.pendingReceives = Queues.newConcurrentLinkedQueue();
    }

    @Override
    public Message receive() throws PulsarClientException {
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                throw new PulsarClientException.AlreadyClosedException("Consumer already closed");
            }
            case Failed: 
            case Uninitialized: {
                throw new PulsarClientException.NotConnectedException();
            }
        }
        return this.internalReceive();
    }

    @Override
    public CompletableFuture<Message> receiveAsync() {
        if (this.listener != null) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set"));
        }
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Consumer already closed"));
            }
            case Failed: 
            case Uninitialized: {
                return FutureUtil.failedFuture(new PulsarClientException.NotConnectedException());
            }
        }
        return this.internalReceiveAsync();
    }

    protected abstract Message internalReceive() throws PulsarClientException;

    protected abstract CompletableFuture<Message> internalReceiveAsync();

    @Override
    public Message receive(int timeout, TimeUnit unit) throws PulsarClientException {
        if (this.conf.getReceiverQueueSize() == 0) {
            throw new PulsarClientException.InvalidConfigurationException("Can't use receive with timeout, if the queue size is 0");
        }
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                throw new PulsarClientException.AlreadyClosedException("Consumer already closed");
            }
            case Failed: 
            case Uninitialized: {
                throw new PulsarClientException.NotConnectedException();
            }
        }
        return this.internalReceive(timeout, unit);
    }

    protected abstract Message internalReceive(int var1, TimeUnit var2) throws PulsarClientException;

    @Override
    public void acknowledge(Message message) throws PulsarClientException {
        try {
            this.acknowledge(message.getMessageId());
        }
        catch (NullPointerException npe) {
            throw new PulsarClientException.InvalidMessageException(npe.getMessage());
        }
    }

    @Override
    public void acknowledge(MessageId messageId) throws PulsarClientException {
        try {
            this.acknowledgeAsync(messageId).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public void acknowledgeCumulative(Message message) throws PulsarClientException {
        try {
            this.acknowledgeCumulative(message.getMessageId());
        }
        catch (NullPointerException npe) {
            throw new PulsarClientException.InvalidMessageException(npe.getMessage());
        }
    }

    @Override
    public void acknowledgeCumulative(MessageId messageId) throws PulsarClientException {
        try {
            this.acknowledgeCumulativeAsync(messageId).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public CompletableFuture<Void> acknowledgeAsync(Message message) {
        try {
            return this.acknowledgeAsync(message.getMessageId());
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    @Override
    public CompletableFuture<Void> acknowledgeCumulativeAsync(Message message) {
        try {
            return this.acknowledgeCumulativeAsync(message.getMessageId());
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    @Override
    public CompletableFuture<Void> acknowledgeAsync(MessageId messageId) {
        return this.doAcknowledge(messageId, PulsarApi.CommandAck.AckType.Individual);
    }

    @Override
    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId messageId) {
        if (!this.isCumulativeAcknowledgementAllowed(this.conf.getSubscriptionType())) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidConfigurationException("Cannot use cumulative acks on a non-exclusive subscription"));
        }
        return this.doAcknowledge(messageId, PulsarApi.CommandAck.AckType.Cumulative);
    }

    protected abstract CompletableFuture<Void> doAcknowledge(MessageId var1, PulsarApi.CommandAck.AckType var2);

    @Override
    public void unsubscribe() throws PulsarClientException {
        try {
            this.unsubscribeAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public abstract CompletableFuture<Void> unsubscribeAsync();

    @Override
    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public abstract CompletableFuture<Void> closeAsync();

    private boolean isCumulativeAcknowledgementAllowed(SubscriptionType type) {
        return SubscriptionType.Shared != type;
    }

    protected PulsarApi.CommandSubscribe.SubType getSubType() {
        SubscriptionType type = this.conf.getSubscriptionType();
        switch (type) {
            case Exclusive: {
                return PulsarApi.CommandSubscribe.SubType.Exclusive;
            }
            case Shared: {
                return PulsarApi.CommandSubscribe.SubType.Shared;
            }
            case Failover: {
                return PulsarApi.CommandSubscribe.SubType.Failover;
            }
        }
        return null;
    }

    public abstract boolean isConnected();

    public abstract int getAvailablePermits();

    public abstract int numMessagesInQueue();

    public CompletableFuture<Consumer> subscribeFuture() {
        return this.subscribeFuture;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getSubscription() {
        return this.subscription;
    }

    protected abstract void redeliverUnacknowledgedMessages(Set<MessageIdImpl> var1);

    static enum ConsumerType {
        PARTITIONED,
        NON_PARTITIONED;

    }
}

