/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.client.api.ConsumerConfiguration;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerStatsDisabled;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TimerTask stat;
    private Timeout statTimeout;
    private ConsumerImpl consumer;
    private PulsarClientImpl pulsarClient;
    private long oldTime;
    private long statsIntervalSeconds;
    private final LongAdder numMsgsReceived;
    private final LongAdder numBytesReceived;
    private final LongAdder numReceiveFailed;
    private final LongAdder numAcksSent;
    private final LongAdder numAcksFailed;
    private final LongAdder totalMsgsReceived;
    private final LongAdder totalBytesReceived;
    private final LongAdder totalReceiveFailed;
    private final LongAdder totalAcksSent;
    private final LongAdder totalAcksFailed;
    private final DecimalFormat throughputFormat;
    public static final ConsumerStats CONSUMER_STATS_DISABLED = new ConsumerStatsDisabled();
    private static final Logger log = LoggerFactory.getLogger(ConsumerStats.class);

    public ConsumerStats() {
        this.numMsgsReceived = null;
        this.numBytesReceived = null;
        this.numReceiveFailed = null;
        this.numAcksSent = null;
        this.numAcksFailed = null;
        this.totalMsgsReceived = null;
        this.totalBytesReceived = null;
        this.totalReceiveFailed = null;
        this.totalAcksSent = null;
        this.totalAcksFailed = null;
        this.throughputFormat = null;
    }

    public ConsumerStats(PulsarClientImpl pulsarClient, ConsumerConfiguration conf, ConsumerImpl consumer) {
        this.pulsarClient = pulsarClient;
        this.consumer = consumer;
        this.statsIntervalSeconds = pulsarClient.getConfiguration().getStatsIntervalSeconds();
        this.numMsgsReceived = new LongAdder();
        this.numBytesReceived = new LongAdder();
        this.numReceiveFailed = new LongAdder();
        this.numAcksSent = new LongAdder();
        this.numAcksFailed = new LongAdder();
        this.totalMsgsReceived = new LongAdder();
        this.totalBytesReceived = new LongAdder();
        this.totalReceiveFailed = new LongAdder();
        this.totalAcksSent = new LongAdder();
        this.totalAcksFailed = new LongAdder();
        this.throughputFormat = new DecimalFormat("0.00");
        this.init(conf);
    }

    private void init(ConsumerConfiguration conf) {
        ObjectMapper m = new ObjectMapper();
        m.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        try {
            log.info("Starting Pulsar consumer perf with config: {}", (Object)w.writeValueAsString(conf));
            log.info("Pulsar client config: {}", (Object)w.writeValueAsString(this.pulsarClient.getConfiguration()));
        }
        catch (IOException e) {
            log.error("Failed to dump config info: {}", (Throwable)e);
        }
        this.stat = timeout -> {
            if (timeout.isCancelled()) {
                return;
            }
            try {
                long now = System.nanoTime();
                double elapsed = (double)(now - this.oldTime) / 1.0E9;
                this.oldTime = now;
                long currentNumMsgsReceived = this.numMsgsReceived.sumThenReset();
                long currentNumBytesReceived = this.numBytesReceived.sumThenReset();
                long currentNumReceiveFailed = this.numReceiveFailed.sumThenReset();
                long currentNumAcksSent = this.numAcksSent.sumThenReset();
                long currentNumAcksFailed = this.numAcksFailed.sumThenReset();
                this.totalMsgsReceived.add(currentNumMsgsReceived);
                this.totalBytesReceived.add(currentNumBytesReceived);
                this.totalReceiveFailed.add(currentNumReceiveFailed);
                this.totalAcksSent.add(currentNumAcksSent);
                this.totalAcksFailed.add(currentNumAcksFailed);
                if ((currentNumMsgsReceived | currentNumBytesReceived | currentNumReceiveFailed | currentNumAcksSent | currentNumAcksFailed) != 0L) {
                    log.info("[{}] [{}] [{}] Prefetched messages: {} --- Consume throughput: {} msgs/s --- Throughput received: {} msg/s --- {} Mbit/s --- Ack sent rate: {} ack/s --- Failed messages: {} --- Failed acks: {}", new Object[]{this.consumer.getTopic(), this.consumer.getSubscription(), this.consumer.consumerName, this.consumer.incomingMessages.size(), this.throughputFormat.format((double)currentNumMsgsReceived / elapsed), this.throughputFormat.format((double)currentNumBytesReceived / elapsed * 8.0 / 1024.0 / 1024.0), this.throughputFormat.format((double)currentNumAcksSent / elapsed), currentNumReceiveFailed, currentNumAcksFailed});
                }
            }
            catch (Exception e) {
                log.error("[{}] [{}] [{}]: {}", new Object[]{this.consumer.getTopic(), this.consumer.subscription, this.consumer.consumerName, e.getMessage()});
            }
            finally {
                this.statTimeout = this.pulsarClient.timer().newTimeout(this.stat, this.statsIntervalSeconds, TimeUnit.SECONDS);
            }
        };
        this.oldTime = System.nanoTime();
        this.statTimeout = this.pulsarClient.timer().newTimeout(this.stat, this.statsIntervalSeconds, TimeUnit.SECONDS);
    }

    void updateNumMsgsReceived(Message message) {
        if (message != null) {
            this.numMsgsReceived.increment();
            this.numBytesReceived.add(message.getData().length);
        }
    }

    void incrementNumAcksSent(long numAcks) {
        this.numAcksSent.add(numAcks);
    }

    void incrementNumAcksFailed() {
        this.numAcksFailed.increment();
    }

    void incrementNumReceiveFailed() {
        this.numReceiveFailed.increment();
    }

    Timeout getStatTimeout() {
        return this.statTimeout;
    }

    void reset() {
        this.numMsgsReceived.reset();
        this.numBytesReceived.reset();
        this.numReceiveFailed.reset();
        this.numAcksSent.reset();
        this.numAcksFailed.reset();
        this.totalMsgsReceived.reset();
        this.totalBytesReceived.reset();
        this.totalReceiveFailed.reset();
        this.totalAcksSent.reset();
        this.totalAcksFailed.reset();
    }

    void updateCumulativeStats(ConsumerStats stats) {
        if (stats == null) {
            return;
        }
        this.numMsgsReceived.add(stats.numMsgsReceived.longValue());
        this.numBytesReceived.add(stats.numBytesReceived.longValue());
        this.numReceiveFailed.add(stats.numReceiveFailed.longValue());
        this.numAcksSent.add(stats.numAcksSent.longValue());
        this.numAcksFailed.add(stats.numAcksFailed.longValue());
        this.totalMsgsReceived.add(stats.totalMsgsReceived.longValue());
        this.totalBytesReceived.add(stats.totalBytesReceived.longValue());
        this.totalReceiveFailed.add(stats.totalReceiveFailed.longValue());
        this.totalAcksSent.add(stats.totalAcksSent.longValue());
        this.totalAcksFailed.add(stats.totalAcksFailed.longValue());
    }

    public long getNumMsgsReceived() {
        return this.numMsgsReceived.longValue();
    }

    public long getNumBytesReceived() {
        return this.numBytesReceived.longValue();
    }

    public long getNumAcksSent() {
        return this.numAcksSent.longValue();
    }

    public long getNumAcksFailed() {
        return this.numAcksFailed.longValue();
    }

    public long getNumReceiveFailed() {
        return this.numReceiveFailed.longValue();
    }

    public long getTotalMsgsReceived() {
        return this.totalMsgsReceived.longValue();
    }

    public long getTotalBytesReceived() {
        return this.totalBytesReceived.longValue();
    }

    public long getTotalReceivedFailed() {
        return this.totalReceiveFailed.longValue();
    }

    public long getTotalAcksSent() {
        return this.totalAcksSent.longValue();
    }

    public long getTotalAcksFailed() {
        return this.totalAcksFailed.longValue();
    }
}

