/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.com.google.protobuf.UninitializedMessageException;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.protobuf.ByteBufCodedOutputStream;

public class MessageIdImpl
implements MessageId,
Comparable<MessageIdImpl> {
    protected final long ledgerId;
    protected final long entryId;
    protected final int partitionIndex;

    private MessageIdImpl() {
        this(-1L, -1L, -1);
    }

    public MessageIdImpl(long ledgerId, long entryId, int partitionIndex) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.partitionIndex = partitionIndex;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    @Override
    public int compareTo(MessageIdImpl other) {
        return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).compare(this.getPartitionIndex(), other.getPartitionIndex()).result();
    }

    public int hashCode() {
        return (int)(31L * (this.ledgerId + 31L * this.entryId) + (long)this.partitionIndex);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId && this.partitionIndex == other.partitionIndex;
        }
        return false;
    }

    public String toString() {
        return String.format("%d:%d:%d", this.ledgerId, this.entryId, this.partitionIndex);
    }

    public static MessageId fromByteArray(byte[] data) throws IOException {
        PulsarApi.MessageIdData idData;
        Preconditions.checkNotNull(data);
        ByteBufCodedInputStream inputStream = ByteBufCodedInputStream.get(Unpooled.wrappedBuffer(data, 0, data.length));
        PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
        try {
            idData = builder.mergeFrom(inputStream, null).build();
        }
        catch (UninitializedMessageException e) {
            throw new IOException(e);
        }
        MessageIdImpl messageId = idData.hasBatchIndex() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex()) : new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        inputStream.recycle();
        builder.recycle();
        idData.recycle();
        return messageId;
    }

    protected byte[] toByteArray(int batchIndex) {
        PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
        builder.setLedgerId(this.ledgerId);
        builder.setEntryId(this.entryId);
        if (this.partitionIndex >= 0) {
            builder.setPartition(this.partitionIndex);
        }
        if (batchIndex != -1) {
            builder.setBatchIndex(batchIndex);
        }
        PulsarApi.MessageIdData msgId = builder.build();
        int size = msgId.getSerializedSize();
        ByteBuf serialized = Unpooled.buffer(size, size);
        ByteBufCodedOutputStream stream = ByteBufCodedOutputStream.get(serialized);
        try {
            msgId.writeTo(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        msgId.recycle();
        builder.recycle();
        stream.recycle();
        return serialized.array();
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(-1);
    }
}

