/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageRouter;

public class RoundRobinPartitionMessageRouterImpl
implements MessageRouter {
    private static final AtomicIntegerFieldUpdater<RoundRobinPartitionMessageRouterImpl> PARTITION_INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RoundRobinPartitionMessageRouterImpl.class, "partitionIndex");
    private volatile int partitionIndex = 0;
    private final int numPartitions;

    public RoundRobinPartitionMessageRouterImpl(int numPartitions) {
        this.numPartitions = numPartitions;
        PARTITION_INDEX_UPDATER.set(this, 0);
    }

    @Override
    public int choosePartition(Message msg) {
        if (msg.hasKey()) {
            return (msg.getKey().hashCode() & Integer.MAX_VALUE) % this.numPartitions;
        }
        return (PARTITION_INDEX_UPDATER.getAndIncrement(this) & Integer.MAX_VALUE) % this.numPartitions;
    }
}

