/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDataTls;

public class AuthenticationTls
implements Authentication {
    private String certFilePath;
    private String keyFilePath;

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getAuthMethodName() {
        return "tls";
    }

    @Override
    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            return new AuthenticationDataTls(this.certFilePath, this.keyFilePath);
        }
        catch (Exception e) {
            throw new PulsarClientException(e);
        }
    }

    @Override
    public void configure(Map<String, String> authParams) {
        this.certFilePath = authParams.get("tlsCertFile");
        this.keyFilePath = authParams.get("tlsKeyFile");
    }

    @Override
    public void start() throws PulsarClientException {
    }
}

