/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches;

import org.apache.pulsar.shade.com.yahoo.sketches.ArrayOfItemsSerDe;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.NativeMemory;

public class ArrayOfUtf16StringsSerDe
implements ArrayOfItemsSerDe<String> {
    private static final byte TYPE = 4;

    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        for (int i = 0; i < items.length; ++i) {
            length += items[i].length() * 2 + 4;
        }
        byte[] bytes = new byte[length];
        NativeMemory mem = new NativeMemory(bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, items[i].length());
            mem.putCharArray(offsetBytes += 4L, items[i].toCharArray(), 0, items[i].length());
            offsetBytes += (long)(items[i].length() * 2);
        }
        return bytes;
    }

    public String[] deserializeFromMemory(Memory mem, int numItems) {
        String[] array = new String[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            int strLength = mem.getInt(offsetBytes);
            char[] chars = new char[strLength];
            mem.getCharArray(offsetBytes += 4L, chars, 0, strLength);
            array[i] = new String(chars);
            offsetBytes += (long)(strLength * 2);
        }
        return array;
    }

    @Override
    public byte getType() {
        return 4;
    }
}

