/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches;

import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesStateException;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;

public final class HashOperations {
    private static final int STRIDE_HASH_BITS = 7;
    public static final int STRIDE_MASK = 127;

    private HashOperations() {
    }

    public static int countPart(long[] srcArr, int lgArrLongs, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = 1 << lgArrLongs;
        while (i-- > 0) {
            long hash = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int count(long[] srcArr, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = srcArr.length;
        while (i-- > 0) {
            long hash = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            ++cnt;
        }
        return cnt;
    }

    private static int getStride(long hash, int lgArrLongs) {
        return 2 * (int)(hash >> lgArrLongs & 0x7FL) + 1;
    }

    public static int hashSearch(long[] hashTable, int lgArrLongs, long hash) {
        if (hash == 0L) {
            throw new SketchesArgumentException("Given hash cannot be zero: " + hash);
        }
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int curProbe = (int)(hash & (long)arrayMask);
        while (hashTable[curProbe] != 0L) {
            if (hashTable[curProbe] == hash) {
                return curProbe;
            }
            curProbe = curProbe + stride & arrayMask;
        }
        return -1;
    }

    public static int hashArrayInsert(long[] srcArr, long[] hashTable, int lgArrLongs, long thetaLong) {
        int count = 0;
        int arrLen = srcArr.length;
        HashOperations.checkThetaCorruption(thetaLong);
        for (int i = 0; i < arrLen; ++i) {
            long hash = srcArr[i];
            HashOperations.checkHashCorruption(hash);
            if (HashOperations.continueCondition(thetaLong, hash) || HashOperations.hashSearchOrInsert(hashTable, lgArrLongs, hash) >= 0) continue;
            ++count;
        }
        return count;
    }

    public static int hashSearchOrInsert(long[] hashTable, int lgArrLongs, long hash) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int curProbe = (int)(hash & (long)arrayMask);
        while (hashTable[curProbe] != 0L) {
            if (hashTable[curProbe] == hash) {
                return curProbe;
            }
            curProbe = curProbe + stride & arrayMask;
        }
        hashTable[curProbe] = hash;
        return ~curProbe;
    }

    public static int hashInsertOnly(long[] hashTable, int lgArrLongs, long hash) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int curProbe = (int)(hash & (long)arrayMask);
        while (hashTable[curProbe] != 0L) {
            curProbe = curProbe + stride & arrayMask;
        }
        hashTable[curProbe] = hash;
        return curProbe;
    }

    public static int hashSearchOrInsert(Memory mem, int lgArrLongs, long hash, int memOffsetBytes) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int curProbe = (int)(hash & (long)arrayMask);
        int curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes;
        long curArrayHash = mem.getLong(curProbeOffsetBytes);
        while (curArrayHash != 0L) {
            if (curArrayHash == hash) {
                return curProbe;
            }
            curProbe = curProbe + stride & arrayMask;
            curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes;
            curArrayHash = mem.getLong(curProbeOffsetBytes);
        }
        mem.putLong(curProbeOffsetBytes, hash);
        return ~curProbe;
    }

    public static int hashInsertOnly(Memory mem, int lgArrLongs, long hash, int memOffsetBytes) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int curProbe = (int)(hash & (long)arrayMask);
        int curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes;
        long curArrayHash = mem.getLong(curProbeOffsetBytes);
        while (curArrayHash != 0L) {
            curProbe = curProbe + stride & arrayMask;
            curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes;
            curArrayHash = mem.getLong(curProbeOffsetBytes);
        }
        mem.putLong(curProbeOffsetBytes, hash);
        return curProbe;
    }

    public static void checkThetaCorruption(long thetaLong) {
        if ((thetaLong | thetaLong - 1L) < 0L) {
            throw new SketchesStateException("Data Corruption: thetaLong was negative or zero: ThetaLong: " + thetaLong);
        }
    }

    public static void checkHashCorruption(long hash) {
        if (hash < 0L) {
            throw new SketchesArgumentException("Data Corruption: hash was negative: Hash: " + hash);
        }
    }

    public static boolean continueCondition(long thetaLong, long hash) {
        return (hash - 1L | thetaLong - hash - 1L) < 0L;
    }

    public static void checkHashAndThetaCorruption(long thetaLong, long hash) {
        if ((hash | thetaLong | thetaLong - 1L) < 0L) {
            throw new SketchesStateException("Data Corruption: Either hash was negative or thetaLong was negative or zero: Hash: " + hash + ", ThetaLong: " + thetaLong);
        }
    }
}

