/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import java.util.Random;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

public abstract class DoublesSketch {
    protected final int k_;
    protected long n_;
    public static final Random rand = new Random();
    public static final int DEFAULT_K = 128;

    DoublesSketch(int k) {
        Util.checkK(k);
        this.k_ = k;
        this.n_ = 0L;
    }

    public static final DoublesSketchBuilder builder() {
        return new DoublesSketchBuilder();
    }

    public abstract void update(double var1);

    public abstract double getQuantile(double var1);

    public abstract double[] getQuantiles(double[] var1);

    public double[] getQuantiles(int evenlySpaced) {
        return this.getQuantiles(DoublesSketch.getEvenlySpaced(evenlySpaced));
    }

    static double[] getEvenlySpaced(int evenlySpaced) {
        double frac;
        int n = evenlySpaced;
        if (n <= 0) {
            throw new SketchesArgumentException("EvenlySpaced must be > zero.");
        }
        double[] fractions = new double[n];
        fractions[0] = frac = 0.0;
        for (int i = 1; i < n; ++i) {
            fractions[i] = frac = (double)i / (double)(n - 1);
        }
        if (n > 1) {
            fractions[n - 1] = 1.0;
        }
        return fractions;
    }

    public abstract double[] getPMF(double[] var1);

    public abstract double[] getCDF(double[] var1);

    public abstract int getK();

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public long getN() {
        return this.n_;
    }

    public double getNormalizedRankError() {
        return DoublesSketch.getNormalizedRankError(this.getK());
    }

    public static double getNormalizedRankError(int k) {
        return Util.EpsilonFromK.getAdjustedEpsilon(k);
    }

    public boolean isEmpty() {
        return this.n_ == 0L;
    }

    public abstract void reset();

    public abstract byte[] toByteArray();

    public String toString() {
        return this.toString(true, false);
    }

    public abstract String toString(boolean var1, boolean var2);

    public abstract DoublesSketch downSample(int var1);

    public static DoublesSketch heapify(Memory srcMem) {
        return HeapDoublesSketch.getInstance(srcMem);
    }

    public int getRetainedItems() {
        return Util.computeRetainedItems(this.getK(), this.getN());
    }

    public int getStorageBytes() {
        if (this.isEmpty()) {
            return 8;
        }
        return 32 + 8 * Util.computeRetainedItems(this.getK(), this.getN());
    }

    public abstract void putMemory(Memory var1);

    abstract int getBaseBufferCount();

    long getBitPattern() {
        return Util.computeBitPattern(this.k_, this.n_);
    }

    abstract int getCombinedBufferItemCapacity();

    abstract double[] getCombinedBuffer();
}

