/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

public class DoublesSketchBuilder {
    private int bK = 128;

    public DoublesSketchBuilder setK(int k) {
        Util.checkK(k);
        this.bK = k;
        return this;
    }

    public int getK() {
        return this.bK;
    }

    public DoublesSketch build() {
        return HeapDoublesSketch.getInstance(this.bK);
    }

    public DoublesSketch build(int k) {
        this.setK(k);
        return this.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuantileSketchBuilder configuration:").append(Util.LS);
        sb.append("K:").append('\t').append(this.bK).append(Util.LS);
        return sb.toString();
    }
}

