/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

final class DoublesUtil {
    DoublesUtil() {
    }

    static final void validateValues(double[] values) {
        int lenM1 = values.length - 1;
        for (int j = 0; j < lenM1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    static long[] internalBuildHistogram(double[] splitPoints, HeapDoublesSketch sketch) {
        long myBitPattern;
        double[] levelsArr;
        double[] baseBuffer = levelsArr = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        DoublesUtil.validateValues(splitPoints);
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        long[] counters = new long[numCounters];
        long weight = 1L;
        if (numSplitPoints < 50) {
            DoublesUtil.bilinearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters);
        } else {
            Arrays.sort(baseBuffer, 0, bbCount);
            DoublesUtil.linearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters);
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight += weight;
            if ((myBitPattern & 1L) > 0L) {
                DoublesUtil.linearTimeIncrementHistogramCounters(levelsArr, (2 + lvl) * k, k, weight, splitPoints, counters);
            }
            ++lvl;
        }
        return counters;
    }

    static void processFullBaseBuffer(HeapDoublesSketch sketch) {
        int bbCount = sketch.getBaseBufferCount();
        long n = sketch.getN();
        assert (bbCount == 2 * sketch.getK());
        DoublesUtil.maybeGrowLevels(n, sketch);
        double[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount);
        DoublesUtil.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        assert (n / (long)(2 * sketch.getK()) == sketch.getBitPattern());
    }

    static void inPlacePropagateCarry(int startingLevel, double[] sizeKBuf, int sizeKStart, double[] size2KBuf, int size2KStart, boolean doUpdateVersion, HeapDoublesSketch sketch) {
        double[] levelsArr = sketch.getCombinedBuffer();
        int k = sketch.getK();
        long bitPattern = sketch.bitPattern_;
        int endingLevel = Util.positionOfLowestZeroBitStartingAt(bitPattern, startingLevel);
        if (doUpdateVersion) {
            DoublesUtil.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        } else {
            System.arraycopy(sizeKBuf, sizeKStart, levelsArr, (2 + endingLevel) * k, k);
        }
        for (int lvl = startingLevel; lvl < endingLevel; ++lvl) {
            assert ((bitPattern & 1L << lvl) > 0L);
            DoublesUtil.mergeTwoSizeKBuffers(levelsArr, (2 + lvl) * k, levelsArr, (2 + endingLevel) * k, size2KBuf, size2KStart, k);
            DoublesUtil.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        }
        sketch.bitPattern_ = bitPattern + (1L << startingLevel);
    }

    static void maybeGrowLevels(long newN, HeapDoublesSketch sketch) {
        int k = sketch.getK();
        int numLevelsNeeded = Util.computeNumLevelsNeeded(k, newN);
        if (numLevelsNeeded == 0) {
            return;
        }
        assert (newN >= 2L * (long)k);
        assert (numLevelsNeeded > 0);
        int spaceNeeded = (2 + numLevelsNeeded) * k;
        if (spaceNeeded <= sketch.getCombinedBufferItemCapacity()) {
            return;
        }
        sketch.combinedBuffer_ = Arrays.copyOf(sketch.getCombinedBuffer(), spaceNeeded);
        sketch.combinedBufferItemCapacity_ = spaceNeeded;
    }

    static void growBaseBuffer(HeapDoublesSketch sketch) {
        int newSize;
        double[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferItemCapacity();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferItemCapacity_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }

    static void downSamplingMergeInto(HeapDoublesSketch src, HeapDoublesSketch tgt) {
        int targetK = tgt.getK();
        int sourceK = src.getK();
        if (sourceK % targetK != 0) {
            throw new SketchesArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = sourceK / targetK;
        org.apache.pulsar.shade.com.yahoo.sketches.Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        double[] sourceLevels = src.getCombinedBuffer();
        double[] sourceBaseBuffer = src.getCombinedBuffer();
        long nFinal = tgt.getN() + src.getN();
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(sourceBaseBuffer[i]);
        }
        DoublesUtil.maybeGrowLevels(nFinal, tgt);
        double[] scratchBuf = new double[2 * targetK];
        double[] downBuf = new double[targetK];
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                DoublesUtil.justZipWithStride(sourceLevels, (2 + srcLvl) * sourceK, downBuf, 0, targetK, downFactor);
                DoublesUtil.inPlacePropagateCarry(srcLvl + lgDownFactor, downBuf, 0, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (long)(2 * targetK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        if (srcMax > tgtMax) {
            tgt.maxValue_ = srcMax;
        }
        if (srcMin < tgtMin) {
            tgt.minValue_ = srcMin;
        }
    }

    private static void zipSize2KBuffer(double[] bufA, int startA, double[] bufC, int startC, int k) {
        int randomOffset = DoublesSketch.rand.nextBoolean() ? 1 : 0;
        int limC = startC + k;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += 2;
        }
    }

    private static void justZipWithStride(double[] bufA, int startA, double[] bufC, int startC, int kC, int stride) {
        int randomOffset = DoublesSketch.rand.nextInt(stride);
        int limC = startC + kC;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += stride;
        }
    }

    private static void mergeTwoSizeKBuffers(double[] keySrc1, int arrStart1, double[] keySrc2, int arrStart2, double[] keyDst, int arrStart3, int k) {
        int arrStop1 = arrStart1 + k;
        int arrStop2 = arrStart2 + k;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc2[i2] < keySrc1[i1]) {
                keyDst[i3++] = keySrc2[i2++];
                continue;
            }
            keyDst[i3++] = keySrc1[i1++];
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc1, i1, keyDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc1, i2, keyDst, i3, arrStop2 - i2);
        }
    }

    static void bilinearTimeIncrementHistogramCounters(double[] samples, int offset, int numSamples, long weight, double[] splitPoints, long[] counters) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < numSamples; ++i) {
            double splitpoint;
            double sample = samples[i + offset];
            int j = 0;
            for (j = 0; j < splitPoints.length && !(sample < (splitpoint = splitPoints[j])); ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + weight;
        }
    }

    static void linearTimeIncrementHistogramCounters(double[] samples, int offset, int numSamples, long weight, double[] splitPoints, long[] counters) {
        int i = 0;
        int j = 0;
        while (i < numSamples && j < splitPoints.length) {
            if (samples[i + offset] < splitPoints[j]) {
                int n = j;
                counters[n] = counters[n] + weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + weight * (long)(numSamples - i);
        }
    }

    static void blockyTandemMergeSort(double[] keyArr, long[] valArr, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] keyTmp = Arrays.copyOf(keyArr, arrLen);
        long[] valTmp = Arrays.copyOf(valArr, arrLen);
        DoublesUtil.blockyTandemMergeSortRecursion(keyTmp, valTmp, keyArr, valArr, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] keySrc, long[] valSrc, double[] keyDst, long[] valDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        DoublesUtil.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart1, grpLen1, blkSize, arrLim);
        DoublesUtil.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        DoublesUtil.tandemMerge(keySrc, valSrc, arrStart1, arrLen1, arrStart2, arrLen2, keyDst, valDst, arrStart1);
    }

    private static void tandemMerge(double[] keySrc, long[] valSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] keyDst, long[] valDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc[i2] < keySrc[i1]) {
                keyDst[i3] = keySrc[i2];
                valDst[i3] = valSrc[i2];
                ++i3;
                ++i2;
                continue;
            }
            keyDst[i3] = keySrc[i1];
            valDst[i3] = valSrc[i1];
            ++i3;
            ++i1;
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc, i1, keyDst, i3, arrStop1 - i1);
            System.arraycopy(valSrc, i1, valDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc, i2, keyDst, i3, arrStop2 - i2);
            System.arraycopy(valSrc, i2, valDst, i3, arrStop2 - i2);
        }
    }

    static String toString(boolean sketchSummary, boolean dataDetail, HeapDoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        if (dataDetail) {
            sb.append(DoublesUtil.getDataDetail(sketch));
        }
        if (sketchSummary) {
            sb.append(DoublesUtil.getSummary(sketch));
        }
        return sb.toString();
    }

    static String getDataDetail(HeapDoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        sb.append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        int k = sketch.getK();
        long n = sketch.getN();
        int bbCount = sketch.getBaseBufferCount();
        long bitPattern = sketch.getBitPattern();
        double[] combBuf = sketch.getCombinedBuffer();
        sb.append("   BaseBuffer   : ");
        for (int i = 0; i < bbCount; ++i) {
            sb.append(String.format("%10.1f", combBuf[i]));
        }
        sb.append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        int combBufSize = combBuf.length;
        if (n >= (long)(2 * k)) {
            sb.append("   Valid | Level");
            for (int j = 2 * k; j < combBufSize; ++j) {
                if (j % k == 0) {
                    int levelNum = j / k - 2;
                    String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                    String lvl = String.format("%5d", levelNum);
                    sb.append(Util.LS).append("   ").append(validLvl).append(" ").append(lvl).append(": ");
                }
                sb.append(String.format("%10.1f", combBuf[j]));
            }
            sb.append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        }
        sb.append("### END DATA DETAIL").append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        return sb.toString();
    }

    static String getSummary(HeapDoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int k = sketch.getK();
        long n = sketch.getN();
        String nStr = String.format("%,d", n);
        int bbCount = sketch.getBaseBufferCount();
        long bitPattern = sketch.getBitPattern();
        int totLevels = Util.computeNumLevelsNeeded(k, n);
        int validLevels = Util.computeValidLevels(bitPattern);
        boolean empty = sketch.isEmpty();
        int preBytes = empty ? 8 : 16;
        int retItems = sketch.getRetainedItems();
        String retItemsStr = String.format("%,d", retItems);
        int bytes = preBytes + (retItems + 2) * 8;
        double eps = Util.EpsilonFromK.getAdjustedEpsilon(k);
        String epsPct = String.format("%.3f%%", eps * 100.0);
        sb.append(Util.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   K                            : ").append(k).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   N                            : ").append(nStr).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Levels (Total, Valid)        : ").append(totLevels + ", " + validLevels).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   BaseBufferCount              : ").append(bbCount).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Retained Items               : ").append(retItemsStr).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Storage Bytes                : ").append(String.format("%,d", bytes)).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Normalized Rank Error        : ").append(epsPct).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Min Value                    : ").append(String.format("%,.3f", sketch.getMinValue())).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("   Max Value                    : ").append(String.format("%,.3f", sketch.getMaxValue())).append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        sb.append("### END SKETCH SUMMARY").append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        return sb.toString();
    }

    static String printMemData(Memory mem, int k, int n) {
        double d;
        int i;
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS).append("### ").append("MEM DATA DETAIL:").append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        String fmt1 = "\n%10.1f, ";
        String fmt2 = "%10.1f, ";
        int bbCount = Util.computeBaseBufferItems(k, n);
        int ret = Util.computeRetainedItems(k, n);
        sb.append("BaseBuffer Data:");
        for (i = 0; i < bbCount; ++i) {
            d = mem.getDouble(32 + i * 8);
            if (i % k != 0) {
                sb.append(String.format(fmt2, d));
                continue;
            }
            sb.append(String.format(fmt1, d));
        }
        sb.append("\n\nLevel Data:");
        for (i = 0; i < ret - bbCount; ++i) {
            d = mem.getDouble(32 + i * 8 + bbCount * 8);
            if (i % k != 0) {
                sb.append(String.format(fmt2, d));
                continue;
            }
            sb.append(String.format(fmt1, d));
        }
        sb.append("\n### END DATA DETAIL").append(org.apache.pulsar.shade.com.yahoo.sketches.Util.LS);
        return sb.toString();
    }
}

