/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.ItemsSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.ItemsUtil;

class ItemsAuxiliary<T> {
    final long auxN_;
    final Object[] auxSamplesArr_;
    final long[] auxCumWtsArr_;

    ItemsAuxiliary(ItemsSketch<T> qs) {
        int k = qs.getK();
        long n = qs.getN();
        long bitPattern = qs.getBitPattern();
        Object[] combinedBuffer = qs.getCombinedBuffer();
        int baseBufferCount = qs.getBaseBufferCount();
        int numSamples = qs.getRetainedItems();
        Object[] itemsArr = new Object[numSamples];
        long[] cumWtsArr = new long[numSamples + 1];
        ItemsAuxiliary.populateFromQuantilesSketch(k, n, bitPattern, combinedBuffer, baseBufferCount, numSamples, itemsArr, cumWtsArr, qs.getComparator());
        ItemsUtil.blockyTandemMergeSort(itemsArr, cumWtsArr, numSamples, k, qs.getComparator());
        long subtot = 0L;
        for (int i = 0; i < numSamples + 1; ++i) {
            long newSubtot = subtot + cumWtsArr[i];
            cumWtsArr[i] = subtot;
            subtot = newSubtot;
        }
        assert (subtot == n);
        this.auxN_ = n;
        this.auxSamplesArr_ = itemsArr;
        this.auxCumWtsArr_ = cumWtsArr;
    }

    T getQuantile(double phi) {
        assert (0.0 <= phi);
        assert (phi <= 1.0);
        if (this.auxN_ <= 0L) {
            return null;
        }
        long pos = ItemsAuxiliary.posOfPhi(phi, this.auxN_);
        return this.approximatelyAnswerPositionalQuery(pos);
    }

    private static final <T> void populateFromQuantilesSketch(int k, long n, long bitPattern, T[] combinedBuffer, int baseBufferCount, int numSamples, T[] itemsArr, long[] cumWtsArr, Comparator<? super T> comparator) {
        long bits;
        long weight = 1L;
        int nxt = 0;
        assert (bits == n / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight *= 2L;
            if ((bits & 1L) > 0L) {
                int offset = (2 + lvl) * k;
                for (int i = 0; i < k; ++i) {
                    itemsArr[nxt] = combinedBuffer[i + offset];
                    cumWtsArr[nxt] = weight;
                    ++nxt;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = nxt;
        for (int i = 0; i < baseBufferCount; ++i) {
            itemsArr[nxt] = combinedBuffer[i];
            cumWtsArr[nxt] = weight;
            ++nxt;
        }
        assert (nxt == numSamples);
        Arrays.sort(itemsArr, startOfBaseBufferBlock, numSamples, comparator);
        cumWtsArr[numSamples] = 0L;
    }

    private static int searchForChunkContainingPos(long[] arr, long q, int l, int r) {
        assert (l < r);
        assert (arr[l] <= q);
        assert (q < arr[r]);
        if (l + 1 == r) {
            return l;
        }
        int m = l + (r - l) / 2;
        if (arr[m] <= q) {
            return ItemsAuxiliary.searchForChunkContainingPos(arr, q, m, r);
        }
        return ItemsAuxiliary.searchForChunkContainingPos(arr, q, l, m);
    }

    private static int chunkContainingPos(long[] arr, long q) {
        int nominalLength = arr.length - 1;
        assert (nominalLength > 0);
        long n = arr[nominalLength];
        assert (0L <= q);
        assert (q < n);
        int l = 0;
        int r = nominalLength;
        assert (l < r);
        assert (arr[l] <= q);
        assert (q < arr[r]);
        return ItemsAuxiliary.searchForChunkContainingPos(arr, q, l, r);
    }

    private T approximatelyAnswerPositionalQuery(long pos) {
        assert (0L <= pos);
        assert (pos < this.auxN_);
        return (T)this.auxSamplesArr_[ItemsAuxiliary.chunkContainingPos(this.auxCumWtsArr_, pos)];
    }

    private static long posOfPhi(double phi, long n) {
        long pos = (long)Math.floor(phi * (double)n);
        return pos == n ? n - 1L : pos;
    }
}

