/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.ItemsSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

final class ItemsUtil {
    ItemsUtil() {
    }

    static final <T> void validateValues(T[] values, Comparator<? super T> comparator) {
        int lenM1 = values.length - 1;
        for (int j = 0; j < lenM1; ++j) {
            if (values[j] != null && values[j + 1] != null && comparator.compare(values[j], values[j + 1]) < 0) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not null.");
        }
    }

    static <T> long[] internalBuildHistogram(T[] splitPoints, ItemsSketch<T> sketch) {
        long myBitPattern;
        Object[] levelsArr;
        Object[] baseBuffer = levelsArr = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        ItemsUtil.validateValues(splitPoints, sketch.getComparator());
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        long[] counters = new long[numCounters];
        long weight = 1L;
        if (numSplitPoints < 50) {
            ItemsUtil.bilinearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters, sketch.getComparator());
        } else {
            Arrays.sort(baseBuffer, 0, bbCount);
            ItemsUtil.linearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters, sketch.getComparator());
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight += weight;
            if ((myBitPattern & 1L) > 0L) {
                ItemsUtil.linearTimeIncrementHistogramCounters(levelsArr, (2 + lvl) * k, k, weight, splitPoints, counters, sketch.getComparator());
            }
            ++lvl;
        }
        return counters;
    }

    static <T> void processFullBaseBuffer(ItemsSketch<T> sketch) {
        int bbCount = sketch.getBaseBufferCount();
        long n = sketch.getN();
        assert (bbCount == 2 * sketch.getK());
        ItemsUtil.maybeGrowLevels(n, sketch);
        Object[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount);
        ItemsUtil.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        Arrays.fill(baseBuffer, 0, 2 * sketch.getK(), null);
        assert (n / (long)(2 * sketch.getK()) == sketch.getBitPattern());
    }

    static <T> void inPlacePropagateCarry(int startingLevel, T[] sizeKBuf, int sizeKStart, T[] size2KBuf, int size2KStart, boolean doUpdateVersion, ItemsSketch<T> sketch) {
        Object[] levelsArr = sketch.getCombinedBuffer();
        long bitPattern = sketch.getBitPattern();
        int k = sketch.getK();
        int endingLevel = Util.positionOfLowestZeroBitStartingAt(bitPattern, startingLevel);
        if (doUpdateVersion) {
            ItemsUtil.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        } else {
            System.arraycopy(sizeKBuf, sizeKStart, levelsArr, (2 + endingLevel) * k, k);
        }
        for (int lvl = startingLevel; lvl < endingLevel; ++lvl) {
            assert ((bitPattern & 1L << lvl) > 0L);
            ItemsUtil.mergeTwoSizeKBuffers(levelsArr, (2 + lvl) * k, levelsArr, (2 + endingLevel) * k, size2KBuf, size2KStart, k, sketch.getComparator());
            ItemsUtil.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
            Arrays.fill(levelsArr, (2 + lvl) * k, (2 + lvl + 1) * k, null);
        }
        sketch.bitPattern_ = bitPattern + (1L << startingLevel);
    }

    static <T> void maybeGrowLevels(long newN, ItemsSketch<T> sketch) {
        int k = sketch.getK();
        int numLevelsNeeded = Util.computeNumLevelsNeeded(k, newN);
        if (numLevelsNeeded == 0) {
            return;
        }
        assert (newN >= 2L * (long)k);
        assert (numLevelsNeeded > 0);
        int spaceNeeded = (2 + numLevelsNeeded) * k;
        if (spaceNeeded <= sketch.getCombinedBufferAllocatedCount()) {
            return;
        }
        sketch.combinedBuffer_ = Arrays.copyOf(sketch.getCombinedBuffer(), spaceNeeded);
        sketch.combinedBufferItemCapacity_ = spaceNeeded;
    }

    static <T> void growBaseBuffer(ItemsSketch<T> sketch) {
        int newSize;
        Object[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferItemCapacity_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }

    static <T> void downSamplingMergeInto(ItemsSketch<T> src, ItemsSketch<T> tgt) {
        int targetK = tgt.getK();
        int sourceK = src.getK();
        if (sourceK % targetK != 0) {
            throw new SketchesArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = sourceK / targetK;
        org.apache.pulsar.shade.com.yahoo.sketches.Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        Object[] sourceLevels = src.getCombinedBuffer();
        Object[] sourceBaseBuffer = src.getCombinedBuffer();
        long nFinal = tgt.getN() + src.getN();
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(sourceBaseBuffer[i]);
        }
        ItemsUtil.maybeGrowLevels(nFinal, tgt);
        Object[] scratchBuf = new Object[2 * targetK];
        Object[] downBuf = new Object[targetK];
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                ItemsUtil.justZipWithStride(sourceLevels, (2 + srcLvl) * sourceK, downBuf, 0, targetK, downFactor);
                ItemsUtil.inPlacePropagateCarry(srcLvl + lgDownFactor, downBuf, 0, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (long)(2 * targetK) == tgt.getBitPattern());
        T srcMax = src.getMaxValue();
        T srcMin = src.getMinValue();
        T tgtMax = tgt.getMaxValue();
        T tgtMin = tgt.getMinValue();
        if (src.getComparator().compare(srcMax, tgtMax) > 0) {
            tgt.maxValue_ = srcMax;
        }
        if (src.getComparator().compare(srcMin, tgtMin) < 0) {
            tgt.minValue_ = srcMin;
        }
    }

    private static void zipSize2KBuffer(Object[] bufA, int startA, Object[] bufC, int startC, int k) {
        int randomOffset = ItemsSketch.rand.nextBoolean() ? 1 : 0;
        int limC = startC + k;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += 2;
        }
    }

    private static <T> void justZipWithStride(T[] bufSrc, int startSrc, T[] bufC, int startC, int kC, int stride) {
        int randomOffset = ItemsSketch.rand.nextInt(stride);
        int limC = startC + kC;
        int a = startSrc + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufSrc[a];
            a += stride;
        }
    }

    private static <T> void mergeTwoSizeKBuffers(T[] keySrc1, int startSrc1, T[] keySrc2, int arrStart2, T[] keyDst, int arrStart3, int k, Comparator<? super T> comparator) {
        int arrStop1 = startSrc1 + k;
        int arrStop2 = arrStart2 + k;
        int i1 = startSrc1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (comparator.compare(keySrc2[i2], keySrc1[i1]) < 0) {
                keyDst[i3++] = keySrc2[i2++];
                continue;
            }
            keyDst[i3++] = keySrc1[i1++];
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc1, i1, keyDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc1, i2, keyDst, i3, arrStop2 - i2);
        }
    }

    static <T> void bilinearTimeIncrementHistogramCounters(T[] samples, int offset, int numSamples, long weight, T[] splitPoints, long[] counters, Comparator<? super T> comparator) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < numSamples; ++i) {
            T splitpoint;
            T sample = samples[i + offset];
            int j = 0;
            for (j = 0; j < splitPoints.length && comparator.compare(sample, splitpoint = splitPoints[j]) >= 0; ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + weight;
        }
    }

    static <T> void linearTimeIncrementHistogramCounters(T[] samples, int offset, int numSamples, long weight, T[] splitPoints, long[] counters, Comparator<? super T> comparator) {
        int i = 0;
        int j = 0;
        while (i < numSamples && j < splitPoints.length) {
            if (comparator.compare(samples[i + offset], splitPoints[j]) < 0) {
                int n = j;
                counters[n] = counters[n] + weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + weight * (long)(numSamples - i);
        }
    }

    static <T> void blockyTandemMergeSort(T[] keyArr, long[] valArr, int arrLen, int blkSize, Comparator<? super T> comparator) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        T[] keyTmp = Arrays.copyOf(keyArr, arrLen);
        long[] valTmp = Arrays.copyOf(valArr, arrLen);
        ItemsUtil.blockyTandemMergeSortRecursion(keyTmp, valTmp, keyArr, valArr, 0, numblks, blkSize, arrLen, comparator);
    }

    private static <T> void blockyTandemMergeSortRecursion(T[] keySrc, long[] valSrc, T[] keyDst, long[] valDst, int grpStart, int grpLen, int blkSize, int arrLim, Comparator<? super T> comparator) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        ItemsUtil.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart1, grpLen1, blkSize, arrLim, comparator);
        ItemsUtil.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart2, grpLen2, blkSize, arrLim, comparator);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        ItemsUtil.tandemMerge(keySrc, valSrc, arrStart1, arrLen1, arrStart2, arrLen2, keyDst, valDst, arrStart1, comparator);
    }

    private static <T> void tandemMerge(T[] keySrc, long[] valSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, T[] keyDst, long[] valDst, int arrStart3, Comparator<? super T> comparator) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (comparator.compare(keySrc[i2], keySrc[i1]) < 0) {
                keyDst[i3] = keySrc[i2];
                valDst[i3] = valSrc[i2];
                ++i3;
                ++i2;
                continue;
            }
            keyDst[i3] = keySrc[i1];
            valDst[i3] = valSrc[i1];
            ++i3;
            ++i1;
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc, i1, keyDst, i3, arrStop1 - i1);
            System.arraycopy(valSrc, i1, valDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc, i2, keyDst, i3, arrStop2 - i2);
            System.arraycopy(valSrc, i2, valDst, i3, arrStop2 - i2);
        }
    }

    static <T> String toString(boolean sketchSummary, boolean dataDetail, ItemsSketch<T> sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int bbCount = sketch.getBaseBufferCount();
        int combAllocCount = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        long bitPattern = sketch.getBitPattern();
        if (dataDetail) {
            sb.append(Util.LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(Util.LS);
            Object[] items = sketch.getCombinedBuffer();
            sb.append("   BaseBuffer   :");
            if (bbCount > 0) {
                for (int i = 0; i < bbCount; ++i) {
                    sb.append(' ').append(items[i]);
                }
            }
            sb.append(Util.LS);
            int numItems = combAllocCount;
            if (numItems > 2 * k) {
                sb.append("   Valid | Level");
                for (int j = 2 * k; j < numItems; ++j) {
                    if (j % k == 0) {
                        int levelNum = j > 2 * k ? (j - 2 * k) / k : 0;
                        String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                        String lvl = String.format("%5d", levelNum);
                        sb.append(Util.LS).append("   ").append(validLvl).append(" ").append(lvl).append(":");
                    }
                    sb.append(' ').append(items[j]);
                }
                sb.append(Util.LS);
            }
            sb.append("### END DATA DETAIL").append(Util.LS);
        }
        if (sketchSummary) {
            long n = sketch.getN();
            String nStr = String.format("%,d", n);
            int numLevels = Util.computeNumLevelsNeeded(k, n);
            String bufCntStr = String.format("%,d", combAllocCount);
            int preBytes = sketch.isEmpty() ? 8 : 16;
            double eps = Util.EpsilonFromK.getAdjustedEpsilon(k);
            String epsPct = String.format("%.3f%%", eps * 100.0);
            int numSamples = sketch.getRetainedItems();
            String numSampStr = String.format("%,d", numSamples);
            sb.append(Util.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            sb.append("   K                            : ").append(k).append(Util.LS);
            sb.append("   N                            : ").append(nStr).append(Util.LS);
            sb.append("   BaseBufferCount              : ").append(bbCount).append(Util.LS);
            sb.append("   CombinedBufferAllocatedCount : ").append(bufCntStr).append(Util.LS);
            sb.append("   Total Levels                 : ").append(numLevels).append(Util.LS);
            sb.append("   Valid Levels                 : ").append(Util.computeValidLevels(bitPattern)).append(Util.LS);
            sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(Util.LS);
            sb.append("   Valid Samples                : ").append(numSampStr).append(Util.LS);
            sb.append("   Preamble Bytes               : ").append(preBytes).append(Util.LS);
            sb.append("   Normalized Rank Error        : ").append(epsPct).append(Util.LS);
            sb.append("   Min Value                    : ").append(sketch.getMinValue()).append(Util.LS);
            sb.append("   Max Value                    : ").append(sketch.getMaxValue()).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }
}

