/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.theta;

import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.HashOperations;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesStateException;
import org.apache.pulsar.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.CompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.Intersection;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.PreambleUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.SetOperation;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.Sketch;

class DirectIntersection
extends SetOperation
implements Intersection {
    private final short seedHash_;
    private int lgArrLongs_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private final int maxLgArrLongs_;
    private final Memory mem_;

    DirectIntersection(long seed, Memory dstMem) {
        int preLongs = 3;
        this.maxLgArrLongs_ = DirectIntersection.checkMaxLgArrLongs(dstMem);
        long[] preArr = new long[preLongs];
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertSerVer(3, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.INTERSECTION.getID(), pre0);
        this.lgArrLongs_ = 5;
        pre0 = PreambleUtil.insertLgArrLongs(5, pre0);
        this.empty_ = false;
        pre0 = PreambleUtil.insertFlags(0, pre0);
        this.seedHash_ = DirectIntersection.computeSeedHash(seed);
        preArr[0] = pre0 = PreambleUtil.insertSeedHash(this.seedHash_, pre0);
        long pre1 = 0L;
        this.curCount_ = -1;
        pre1 = PreambleUtil.insertCurCount(-1, pre1);
        preArr[1] = pre1 = PreambleUtil.insertP(1.0f, pre1);
        preArr[2] = this.thetaLong_ = Long.MAX_VALUE;
        dstMem.putLongArray(0L, preArr, 0, preLongs);
        this.mem_ = dstMem;
    }

    DirectIntersection(Memory srcMem, long seed) {
        int preLongs = 3;
        long[] preArr = new long[preLongs];
        srcMem.getLongArray(0L, preArr, 0, preLongs);
        long pre0 = preArr[0];
        int preLongsMem = PreambleUtil.extractPreLongs(pre0);
        if (preLongsMem != 3) {
            throw new SketchesArgumentException("PreambleLongs must = 3.");
        }
        int serVer = PreambleUtil.extractSerVer(pre0);
        if (serVer != 3) {
            throw new SketchesArgumentException("Ser Version must = 3");
        }
        int famID = PreambleUtil.extractFamilyID(pre0);
        Family.INTERSECTION.checkFamilyID(famID);
        this.lgArrLongs_ = PreambleUtil.extractLgArrLongs(pre0);
        this.maxLgArrLongs_ = DirectIntersection.checkMaxLgArrLongs(srcMem);
        int flags = PreambleUtil.extractFlags(pre0);
        this.empty_ = (flags & 4) > 0;
        this.seedHash_ = DirectIntersection.computeSeedHash(seed);
        short seedHashMem = srcMem.getShort(6L);
        Util.checkSeedHashes(seedHashMem, this.seedHash_);
        this.curCount_ = srcMem.getInt(8L);
        this.thetaLong_ = srcMem.getLong(16L);
        if (this.empty_ && this.curCount_ != 0) {
            throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + this.empty_ + "," + this.curCount_);
        }
        this.mem_ = srcMem;
    }

    @Override
    public void update(Sketch sketchIn) {
        if (sketchIn == null) {
            if (this.curCount_ < 0) {
                this.curCount_ = this.setCurCount(0);
                this.empty_ = this.setEmpty(true);
                this.thetaLong_ = this.setThetaLong(Long.MAX_VALUE);
            } else {
                this.curCount_ = this.setCurCount(0);
                this.empty_ = this.setEmpty(true);
            }
            return;
        }
        int sketchInEntries = sketchIn.getRetainedEntries(true);
        if (this.curCount_ == 0 || sketchInEntries == 0) {
            Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = this.minThetaLong(sketchIn.getThetaLong());
            this.empty_ = this.setEmpty(this.empty_ || sketchIn.isEmpty());
            this.curCount_ = this.setCurCount(0);
        } else if (this.curCount_ < 0) {
            Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = this.minThetaLong(sketchIn.getThetaLong());
            this.empty_ = this.setEmpty(this.empty_ || sketchIn.isEmpty());
            this.curCount_ = this.setCurCount(sketchIn.getRetainedEntries(true));
            int requiredLgArrLongs = DirectIntersection.computeMinLgArrLongsFromCount(this.curCount_);
            if (requiredLgArrLongs > this.maxLgArrLongs_) {
                throw new SketchesArgumentException("Insufficient dstMem hash table space: " + (1 << requiredLgArrLongs) + " > " + (1 << this.lgArrLongs_));
            }
            this.lgArrLongs_ = this.setLgArrLongs(requiredLgArrLongs);
            this.mem_.clear(24L, 8 << this.lgArrLongs_);
            this.moveDataToHT(sketchIn.getCache(), this.curCount_);
        } else {
            Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
            this.thetaLong_ = this.minThetaLong(sketchIn.getThetaLong());
            this.empty_ = this.setEmpty(this.empty_ || sketchIn.isEmpty());
            this.performIntersect(sketchIn);
        }
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        if (this.curCount_ < 0) {
            throw new SketchesStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        int htLen = 1 << this.lgArrLongs_;
        long[] hashTable = new long[htLen];
        this.mem_.getLongArray(24L, hashTable, 0, htLen);
        long[] compactCacheR = CompactSketch.compactCachePart(hashTable, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public boolean hasResult() {
        return this.mem_.getInt(8L) >= 0;
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        int totalBytes = preBytes + dataBytes;
        byte[] byteArrOut = new byte[totalBytes];
        this.mem_.getByteArray(0L, byteArrOut, 0, totalBytes);
        return byteArrOut;
    }

    @Override
    public void reset() {
        this.lgArrLongs_ = 0;
        this.mem_.putByte(4L, (byte)this.lgArrLongs_);
        this.curCount_ = this.setCurCount(-1);
        this.thetaLong_ = this.setThetaLong(Long.MAX_VALUE);
        this.empty_ = this.setEmpty(false);
    }

    @Override
    public Family getFamily() {
        return Family.INTERSECTION;
    }

    private void performIntersect(Sketch sketchIn) {
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int arrLongsIn = cacheIn.length;
        int htLen = 1 << this.lgArrLongs_;
        long[] hashTable = new long[htLen];
        this.mem_.getLongArray(24L, hashTable, 0, htLen);
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = cacheIn[i];
                if (hashIn <= 0L) continue;
                if (hashIn < this.thetaLong_) {
                    int foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn);
                    if (foundIdx == -1) continue;
                    matchSet[matchSetCount++] = hashIn;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.lgArrLongs_ = this.setLgArrLongs(DirectIntersection.computeMinLgArrLongsFromCount(this.curCount_));
        this.curCount_ = this.setCurCount(matchSetCount);
        this.mem_.clear(24L, 8 << this.lgArrLongs_);
        this.moveDataToHT(matchSet, matchSetCount);
    }

    private void moveDataToHT(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        int preBytes = 24;
        for (int i = 0; i < arrLongsIn; ++i) {
            long hashIn = arr[i];
            if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
            tmpCnt += HashOperations.hashSearchOrInsert(this.mem_, this.lgArrLongs_, hashIn, preBytes) < 0 ? 1 : 0;
        }
        if (tmpCnt != count) {
            throw new SketchesArgumentException("Count Check Exception: got: " + tmpCnt + ", expected: " + count);
        }
    }

    private static final int checkMaxLgArrLongs(Memory dstMem) {
        int preBytes = 24;
        long cap = dstMem.getCapacity();
        int maxLgArrLongs = Integer.numberOfTrailingZeros(Util.floorPowerOf2((int)(cap - (long)preBytes)) >>> 3);
        if (maxLgArrLongs < 5) {
            throw new SketchesArgumentException("dstMem not large enough for minimum sized hash table: " + cap);
        }
        return maxLgArrLongs;
    }

    private final boolean setEmpty(boolean empty) {
        if (empty) {
            this.mem_.setBits(5L, (byte)4);
        } else {
            this.mem_.clearBits(5L, (byte)4);
        }
        return empty;
    }

    private final int setLgArrLongs(int lgArrLongs) {
        this.mem_.putByte(4L, (byte)lgArrLongs);
        return lgArrLongs;
    }

    private final long setThetaLong(long thetaLong) {
        this.mem_.putLong(16L, thetaLong);
        return thetaLong;
    }

    private final long minThetaLong(long skThetaLong) {
        if (skThetaLong < this.thetaLong_) {
            this.mem_.putLong(16L, skThetaLong);
            return skThetaLong;
        }
        return this.thetaLong_;
    }

    private final int setCurCount(int curCount) {
        this.mem_.putInt(8L, curCount);
        return curCount;
    }
}

