/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.tuple;

import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.DeserializeResult;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.DoubleSummary;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.DoubleSummarySetOperations;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.SummaryFactory;

public class DoubleSummaryFactory
implements SummaryFactory<DoubleSummary> {
    private final DoubleSummary.Mode summaryMode_;
    private static final int SERIALIZED_SIZE_BYTES = 1;
    private static final int MODE_BYTE = 0;

    public DoubleSummaryFactory() {
        this.summaryMode_ = DoubleSummary.Mode.Sum;
    }

    public DoubleSummaryFactory(DoubleSummary.Mode summaryMode) {
        this.summaryMode_ = summaryMode;
    }

    @Override
    public DoubleSummary newSummary() {
        return new DoubleSummary(this.summaryMode_);
    }

    public DoubleSummarySetOperations getSummarySetOperations() {
        return new DoubleSummarySetOperations(this.summaryMode_);
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[1];
        NativeMemory mem = new NativeMemory(bytes);
        mem.putByte(0L, (byte)this.summaryMode_.ordinal());
        return bytes;
    }

    public static DeserializeResult<DoubleSummaryFactory> fromMemory(Memory mem) {
        return new DeserializeResult<DoubleSummaryFactory>(new DoubleSummaryFactory(DoubleSummary.Mode.values()[mem.getByte(0L)]), 1);
    }

    @Override
    public DeserializeResult<DoubleSummary> summaryFromMemory(Memory mem) {
        return DoubleSummary.fromMemory(mem);
    }
}

