/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.tuple;

import org.apache.pulsar.shade.com.yahoo.sketches.ResizeFactor;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.SummaryFactory;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.UpdatableSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.UpdatableSummary;

public class UpdatableSketchBuilder<U, S extends UpdatableSummary<U>> {
    private int nomEntries_ = 4096;
    private ResizeFactor resizeFactor_ = DEFAULT_RESIZE_FACTOR;
    private float samplingProbability_ = 1.0f;
    private final SummaryFactory<S> summaryFactory_;
    private static final int DEFAULT_NOMINAL_ENTRIES = 4096;
    private static final float DEFAULT_SAMPLING_PROBABILITY = 1.0f;
    private static final ResizeFactor DEFAULT_RESIZE_FACTOR = ResizeFactor.X8;

    public UpdatableSketchBuilder(SummaryFactory<S> summaryFactory) {
        this.summaryFactory_ = summaryFactory;
    }

    public UpdatableSketchBuilder<U, S> setNominalEntries(int nomEntries) {
        this.nomEntries_ = nomEntries;
        return this;
    }

    public UpdatableSketchBuilder<U, S> setResizeFactor(ResizeFactor resizeFactor) {
        this.resizeFactor_ = resizeFactor;
        return this;
    }

    public UpdatableSketchBuilder<U, S> setSamplingProbability(float samplingProbability) {
        if (samplingProbability < 0.0f || samplingProbability > 1.0f) {
            throw new SketchesArgumentException("sampling probability must be between 0 and 1");
        }
        this.samplingProbability_ = samplingProbability;
        return this;
    }

    public UpdatableSketch<U, S> build() {
        return new UpdatableSketch(this.nomEntries_, this.resizeFactor_.lg(), this.samplingProbability_, this.summaryFactory_);
    }
}

