/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.netty.channel.unix;

import java.nio.ByteBuffer;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.channel.ChannelOutboundBuffer;
import org.apache.pulsar.shade.io.netty.channel.unix.Limits;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = PlatformDependent.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress = PlatformDependent.allocateMemory(CAPACITY);
    private int count;
    private long size;

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    public boolean add(ByteBuf buf) {
        ByteBuffer[] buffers;
        int nioBufferCount = buf.nioBufferCount();
        if (this.count + nioBufferCount > Limits.IOV_MAX) {
            return false;
        }
        if (nioBufferCount == 1) {
            int len = buf.readableBytes();
            if (len == 0) {
                return true;
            }
            long addr = buf.memoryAddress();
            int offset = buf.readerIndex();
            return this.add(addr, offset, len);
        }
        for (ByteBuffer nioBuffer : buffers = buf.nioBuffers()) {
            int len = nioBuffer.remaining();
            if (len == 0) continue;
            int offset = nioBuffer.position();
            long addr = PlatformDependent.directBufferAddress(nioBuffer);
            if (this.add(addr, offset, len)) continue;
            return false;
        }
        return true;
    }

    private boolean add(long addr, int offset, int len) {
        if (len == 0) {
            return true;
        }
        long baseOffset = this.memoryAddress(this.count++);
        long lengthOffset = baseOffset + (long)ADDRESS_SIZE;
        if (Limits.SSIZE_MAX - (long)len < this.size) {
            return false;
        }
        this.size += (long)len;
        if (ADDRESS_SIZE == 8) {
            PlatformDependent.putLong(baseOffset, addr + (long)offset);
            PlatformDependent.putLong(lengthOffset, len);
        } else {
            assert (ADDRESS_SIZE == 4);
            PlatformDependent.putInt(baseOffset, (int)addr + offset);
            PlatformDependent.putInt(lengthOffset, len);
        }
        return true;
    }

    public long processWritten(int index, long written) {
        long baseOffset = this.memoryAddress(index);
        long lengthOffset = baseOffset + (long)ADDRESS_SIZE;
        if (ADDRESS_SIZE == 8) {
            long len = PlatformDependent.getLong(lengthOffset);
            if (len > written) {
                long offset = PlatformDependent.getLong(baseOffset);
                PlatformDependent.putLong(baseOffset, offset + written);
                PlatformDependent.putLong(lengthOffset, len - written);
                return -1L;
            }
            return len;
        }
        assert (ADDRESS_SIZE == 4);
        long len = PlatformDependent.getInt(lengthOffset);
        if (len > written) {
            int offset = PlatformDependent.getInt(baseOffset);
            PlatformDependent.putInt(baseOffset, (int)((long)offset + written));
            PlatformDependent.putInt(lengthOffset, (int)(len - written));
            return -1L;
        }
        return len;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public long memoryAddress(int offset) {
        return this.memoryAddress + (long)(IOV_SIZE * offset);
    }

    public void release() {
        PlatformDependent.freeMemory(this.memoryAddress);
    }

    @Override
    public boolean processMessage(Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            return this.add((ByteBuf)msg);
        }
        return false;
    }
}

