/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.naming;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.DestinationDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.ServiceUnitId;

public class NamespaceName
implements ServiceUnitId {
    private final String namespace;
    private String property;
    private String cluster;
    private String localName;

    public NamespaceName(String namespace) {
        try {
            Preconditions.checkNotNull(namespace);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid null namespace: " + namespace);
        }
        this.validateNamespaceName(namespace);
        this.namespace = namespace;
    }

    public NamespaceName(String property, String cluster, String namespace) {
        NamespaceName.validateNamespaceName(property, cluster, namespace);
        this.namespace = property + '/' + cluster + '/' + namespace;
        this.property = property;
        this.cluster = cluster;
        this.localName = namespace;
    }

    public String getProperty() {
        return this.property;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isGlobal() {
        return "global".equals(this.cluster);
    }

    public String getPersistentTopicName(String localTopic) {
        return this.getDestinationName(DestinationDomain.persistent, localTopic);
    }

    String getDestinationName(DestinationDomain domain, String destination) {
        try {
            Preconditions.checkNotNull(domain);
            NamedEntity.checkName(destination);
            return String.format("%s://%s/%s", domain.toString(), this.namespace, destination);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Null pointer is invalid as domain for destination.", e);
        }
    }

    @Override
    public String toString() {
        return this.namespace;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceName) {
            NamespaceName other = (NamespaceName)obj;
            return Objects.equal(this.namespace, other.namespace);
        }
        return false;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public static void validateNamespaceName(String property, String cluster, String namespace) {
        try {
            Preconditions.checkNotNull(property);
            Preconditions.checkNotNull(cluster);
            Preconditions.checkNotNull(namespace);
            if (property.isEmpty() || cluster.isEmpty() || namespace.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s/%s", property, cluster, namespace));
            }
            NamedEntity.checkName(property);
            NamedEntity.checkName(cluster);
            NamedEntity.checkName(namespace);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s/%s", property, cluster, namespace), e);
        }
    }

    private void validateNamespaceName(String namespace) {
        try {
            Preconditions.checkNotNull(namespace);
            String testUrl = String.format("http://%s", namespace);
            URI uri = new URI(testUrl);
            Preconditions.checkNotNull(uri.getPath());
            NamedEntity.checkURI(uri, testUrl);
            String[] parts = uri.getPath().split("/");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid namespace format. namespace: " + namespace);
            }
            NamespaceName.validateNamespaceName(uri.getHost(), parts[1], parts[2]);
            this.property = uri.getHost();
            this.cluster = parts[1];
            this.localName = parts[2];
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid namespace format. namespace: " + namespace, e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid namespace format. namespace: " + namespace, e);
        }
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this;
    }

    @Override
    public boolean includes(DestinationName dn) {
        return this.equals(dn.getNamespaceObject());
    }
}

