/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;

public class Policies {
    public final AuthPolicies auth_policies = new AuthPolicies();
    public List<String> replication_clusters = Lists.newArrayList();
    public BundlesData bundles = Policies.defaultBundle();
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlog_quota_map = Maps.newHashMap();
    public Map<String, DispatchRate> clusterDispatchRate = Maps.newHashMap();
    public PersistencePolicies persistence = null;
    public Boolean deduplicationEnabled = null;
    public Map<String, Integer> latency_stats_sample_rate = Maps.newHashMap();
    public int message_ttl_in_seconds = 0;
    public RetentionPolicies retention_policies = null;
    public boolean deleted = false;
    public static final String FIRST_BOUNDARY = "0x00000000";
    public static final String LAST_BOUNDARY = "0xffffffff";

    public boolean equals(Object obj) {
        if (obj instanceof Policies) {
            Policies other = (Policies)obj;
            return Objects.equals(this.auth_policies, other.auth_policies) && Objects.equals(this.replication_clusters, other.replication_clusters) && Objects.equals(this.backlog_quota_map, other.backlog_quota_map) && Objects.equals(this.clusterDispatchRate, other.clusterDispatchRate) && Objects.equals(this.deduplicationEnabled, other.deduplicationEnabled) && Objects.equals(this.persistence, other.persistence) && Objects.equals(this.bundles, other.bundles) && Objects.equals(this.latency_stats_sample_rate, other.latency_stats_sample_rate) && this.message_ttl_in_seconds == other.message_ttl_in_seconds && Objects.equals(this.retention_policies, other.retention_policies);
        }
        return false;
    }

    public static BundlesData defaultBundle() {
        BundlesData bundle = new BundlesData(1);
        ArrayList<String> boundaries = Lists.newArrayList();
        boundaries.add(FIRST_BOUNDARY);
        boundaries.add(LAST_BOUNDARY);
        bundle.setBoundaries(boundaries);
        return bundle;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("auth_policies", this.auth_policies).add("replication_clusters", this.replication_clusters).add("bundles", this.bundles).add("backlog_quota_map", this.backlog_quota_map).add("persistence", this.persistence).add("deduplicationEnabled", this.deduplicationEnabled).add("clusterDispatchRate", this.clusterDispatchRate).add("latency_stats_sample_rate", this.latency_stats_sample_rate).add("message_ttl_in_seconds", this.message_ttl_in_seconds).add("retention_policies", this.retention_policies).add("deleted", this.deleted).toString();
    }
}

