/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public final class FieldParser {
    private static final Map<String, Method> CONVERTERS = new HashMap<String, Method>();
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPES = new HashMap();

    public static <T> T convert(Object from, Class<T> to) {
        Preconditions.checkNotNull(to);
        if (from == null) {
            return null;
        }
        if ((to = FieldParser.wrap(to)).isAssignableFrom(from.getClass())) {
            return (T)to.cast(from);
        }
        String converterId = from.getClass().getName() + "_" + to.getName();
        Method converter = CONVERTERS.get(converterId);
        if (converter == null) {
            throw new UnsupportedOperationException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Requested converter does not exist.");
        }
        try {
            Object val = converter.invoke(to, from);
            return (T)to.cast(val);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Conversion failed with " + e.getMessage(), e);
        }
    }

    public static <T> void update(Map<String, String> properties, T obj) throws IllegalArgumentException {
        Field[] fields = obj.getClass().getDeclaredFields();
        Arrays.stream(fields).forEach(f -> {
            if (properties.containsKey(f.getName())) {
                try {
                    f.setAccessible(true);
                    f.set(obj, FieldParser.value((String)properties.get(f.getName()), f));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("failed to initialize %s field while setting value %s", f.getName(), properties.get(f.getName())), e);
                }
            }
        });
    }

    public static Object value(String strValue, Field field) {
        Preconditions.checkNotNull(field);
        if (field.getGenericType() instanceof ParameterizedType) {
            Class clazz = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (field.getType().equals(List.class)) {
                return FieldParser.stringToList(strValue, clazz);
            }
            if (field.getType().equals(Set.class)) {
                return FieldParser.stringToSet(strValue, clazz);
            }
            throw new IllegalArgumentException(String.format("unsupported field-type %s for %s", field.getType(), field.getName()));
        }
        return FieldParser.convert(strValue, field.getType());
    }

    private static Class<?> wrap(Class<?> type) {
        return WRAPPER_TYPES.containsKey(type) ? WRAPPER_TYPES.get(type) : type;
    }

    private static void initConverters() {
        Method[] methods = FieldParser.class.getDeclaredMethods();
        Arrays.stream(methods).forEach(method -> {
            if (method.getParameterTypes().length == 1) {
                CONVERTERS.put(method.getParameterTypes()[0].getName() + "_" + method.getReturnType().getName(), (Method)method);
            }
        });
    }

    private static void initWrappers() {
        WRAPPER_TYPES.put(Integer.TYPE, Integer.class);
        WRAPPER_TYPES.put(Float.TYPE, Float.class);
        WRAPPER_TYPES.put(Double.TYPE, Double.class);
        WRAPPER_TYPES.put(Long.TYPE, Long.class);
        WRAPPER_TYPES.put(Boolean.TYPE, Boolean.class);
    }

    public static Integer stringToInteger(String val) {
        return Integer.valueOf(FieldParser.trim(val));
    }

    public static Long stringToLong(String val) {
        return Long.valueOf(FieldParser.trim(val));
    }

    public static Double stringToDouble(String val) {
        return Double.valueOf(FieldParser.trim(val));
    }

    public static Float stringToFloat(String val) {
        return Float.valueOf(FieldParser.trim(val));
    }

    public static <T> List<T> stringToList(String val, Class<T> type) {
        String[] tokens = FieldParser.trim(val).split(",");
        return Arrays.stream(tokens).map(t -> FieldParser.convert(t, type)).collect(Collectors.toList());
    }

    public static <T> Set<T> stringToSet(String val, Class<T> type) {
        String[] tokens = FieldParser.trim(val).split(",");
        return Arrays.stream(tokens).map(t -> FieldParser.convert(t, type)).collect(Collectors.toSet());
    }

    private static String trim(String val) {
        Preconditions.checkNotNull(val);
        return val.trim();
    }

    public static String integerToString(Integer value) {
        return value.toString();
    }

    public static String booleanToString(Boolean value) {
        return value.toString();
    }

    public static Boolean stringToBoolean(String value) {
        return Boolean.valueOf(value);
    }

    static {
        FieldParser.initConverters();
        FieldParser.initWrappers();
    }
}

