/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.handler.intercept;

import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseStatus;
import org.apache.pulsar.shade.org.asynchttpclient.filter.FilterContext;
import org.apache.pulsar.shade.org.asynchttpclient.filter.FilterException;
import org.apache.pulsar.shade.org.asynchttpclient.filter.ResponseFilter;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.util.Assertions;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    public ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull("fc", "filterContext");
            }
            catch (FilterException efe) {
                this.requestSender.abort(channel, future, efe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

