/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class ConsumerConfiguration
implements Serializable {
    static long minAckTimeoutMillis = 1000L;
    private static final long serialVersionUID = 1L;
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    private MessageListener messageListener;
    private int receiverQueueSize = 1000;
    private int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    private String consumerName = null;
    private long ackTimeoutMillis = 0L;
    private int priorityLevel = 0;
    private CryptoKeyReader cryptoKeyReader = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private final Map<String, String> properties = new HashMap<String, String>();
    private boolean readCompacted = false;

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public ConsumerConfiguration setAckTimeout(long ackTimeout, TimeUnit timeUnit) {
        long ackTimeoutMillis = timeUnit.toMillis(ackTimeout);
        Preconditions.checkArgument(ackTimeoutMillis >= minAckTimeoutMillis, "Ack timeout should be should be greater than " + minAckTimeoutMillis + " ms");
        this.ackTimeoutMillis = ackTimeoutMillis;
        return this;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public ConsumerConfiguration setSubscriptionType(SubscriptionType subscriptionType) {
        Preconditions.checkNotNull(subscriptionType);
        this.subscriptionType = subscriptionType;
        return this;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public ConsumerConfiguration setMessageListener(MessageListener messageListener) {
        Preconditions.checkNotNull(messageListener);
        this.messageListener = messageListener;
        return this;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public int getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        Preconditions.checkArgument(maxTotalReceiverQueueSizeAcrossPartitions >= this.receiverQueueSize);
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ConsumerConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Preconditions.checkNotNull(cryptoKeyReader);
        this.cryptoKeyReader = cryptoKeyReader;
        return this;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.cryptoFailureAction = action;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public ConsumerConfiguration setReceiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument(receiverQueueSize >= 0, "Receiver queue size cannot be negative");
        this.receiverQueueSize = receiverQueueSize;
        return this;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public ConsumerConfiguration setConsumerName(String consumerName) {
        Preconditions.checkArgument(consumerName != null && !consumerName.equals(""));
        this.consumerName = consumerName;
        return this;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public boolean getReadCompacted() {
        return this.readCompacted;
    }

    public ConsumerConfiguration setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
        return this;
    }

    public ConsumerConfiguration setProperty(String key, String value) {
        Preconditions.checkArgument(key != null);
        Preconditions.checkArgument(value != null);
        this.properties.put(key, value);
        return this;
    }

    public ConsumerConfiguration setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

