/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class ReaderConfiguration
implements Serializable {
    private int receiverQueueSize = 1000;
    private ReaderListener readerListener;
    private String readerName = null;
    private CryptoKeyReader cryptoKeyReader = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private static final long serialVersionUID = 1L;

    public ReaderListener getReaderListener() {
        return this.readerListener;
    }

    public ReaderConfiguration setReaderListener(ReaderListener readerListener) {
        Preconditions.checkNotNull(readerListener);
        this.readerListener = readerListener;
        return this;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ReaderConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Preconditions.checkNotNull(cryptoKeyReader);
        this.cryptoKeyReader = cryptoKeyReader;
        return this;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.cryptoFailureAction = action;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public ReaderConfiguration setReceiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument(receiverQueueSize >= 0, "Receiver queue size cannot be negative");
        this.receiverQueueSize = receiverQueueSize;
        return this;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public ReaderConfiguration setReaderName(String readerName) {
        Preconditions.checkArgument(readerName != null && !readerName.equals(""));
        this.readerName = readerName;
        return this;
    }
}

