/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;

public class BatchMessageIdImpl
extends MessageIdImpl {
    private final int batchIndex;

    public BatchMessageIdImpl(long ledgerId, long entryId, int partitionIndex, int batchIndex) {
        super(ledgerId, entryId, partitionIndex);
        this.batchIndex = batchIndex;
    }

    public BatchMessageIdImpl(MessageIdImpl other) {
        super(other.ledgerId, other.entryId, other.partitionIndex);
        this.batchIndex = other instanceof BatchMessageIdImpl ? ((BatchMessageIdImpl)other).batchIndex : -1;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    @Override
    public int compareTo(MessageId o) {
        if (!(o instanceof BatchMessageIdImpl)) {
            throw new IllegalArgumentException("expected BatchMessageIdImpl object. Got instance of " + o.getClass().getName());
        }
        BatchMessageIdImpl other = (BatchMessageIdImpl)o;
        return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).compare(this.batchIndex, other.batchIndex).compare(this.getPartitionIndex(), other.getPartitionIndex()).result();
    }

    @Override
    public int hashCode() {
        return (int)(31L * (this.ledgerId + 31L * this.entryId) + (long)(31 * this.partitionIndex) + (long)this.batchIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl other = (BatchMessageIdImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId && this.partitionIndex == other.partitionIndex && this.batchIndex == other.batchIndex;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%d:%d:%d:%d", this.ledgerId, this.entryId, this.partitionIndex, this.batchIndex);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.batchIndex);
    }
}

