/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageBuilder;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConfiguration;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.HandlerBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;

public abstract class ProducerBase
extends HandlerBase
implements Producer {
    protected final CompletableFuture<Producer> producerCreatedFuture;
    protected final ProducerConfiguration conf;

    protected ProducerBase(PulsarClientImpl client, String topic, ProducerConfiguration conf, CompletableFuture<Producer> producerCreatedFuture) {
        super(client, topic, new Backoff(100L, TimeUnit.MILLISECONDS, 60L, TimeUnit.SECONDS, Math.max(100L, conf.getSendTimeoutMs() - 100L), TimeUnit.MILLISECONDS));
        this.producerCreatedFuture = producerCreatedFuture;
        this.conf = conf;
    }

    @Override
    public MessageId send(byte[] message) throws PulsarClientException {
        return this.send(MessageBuilder.create().setContent(message).build());
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(byte[] message) {
        return this.sendAsync(MessageBuilder.create().setContent(message).build());
    }

    @Override
    public MessageId send(Message message) throws PulsarClientException {
        try {
            return this.sendAsync(message).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public abstract CompletableFuture<MessageId> sendAsync(Message var1);

    @Override
    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public abstract CompletableFuture<Void> closeAsync();

    public abstract boolean isConnected();

    @Override
    public String getTopic() {
        return this.topic;
    }

    public ProducerConfiguration getConfiguration() {
        return this.conf;
    }

    public CompletableFuture<Producer> producerCreatedFuture() {
        return this.producerCreatedFuture;
    }

    public String toString() {
        return "ProducerBase{topic='" + this.topic + '\'' + '}';
    }
}

