/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.ProducerConfiguration;
import org.apache.pulsar.client.api.TopicMetadata;
import org.apache.pulsar.client.impl.MessageRouterBase;

public class RoundRobinPartitionMessageRouterImpl
extends MessageRouterBase {
    private static final AtomicIntegerFieldUpdater<RoundRobinPartitionMessageRouterImpl> PARTITION_INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RoundRobinPartitionMessageRouterImpl.class, "partitionIndex");
    private volatile int partitionIndex = 0;

    public RoundRobinPartitionMessageRouterImpl(ProducerConfiguration.HashingScheme hashingScheme) {
        super(hashingScheme);
        PARTITION_INDEX_UPDATER.set(this, 0);
    }

    @Override
    public int choosePartition(Message msg, TopicMetadata topicMetadata) {
        if (msg.hasKey()) {
            return this.hash.makeHash(msg.getKey()) % topicMetadata.numPartitions();
        }
        return (PARTITION_INDEX_UPDATER.getAndIncrement(this) & Integer.MAX_VALUE) % topicMetadata.numPartitions();
    }
}

