/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.shade.com.yahoo.sketches.ArrayOfItemsSerDe;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.NativeMemory;

public class ArrayOfStringsSerDe
implements ArrayOfItemsSerDe<String> {
    private static final byte TYPE = 2;

    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        byte[][] itemsBytes = new byte[items.length][];
        for (int i = 0; i < items.length; ++i) {
            itemsBytes[i] = items[i].getBytes(StandardCharsets.UTF_8);
            length += itemsBytes[i].length + 4;
        }
        byte[] bytes = new byte[length];
        NativeMemory mem = new NativeMemory(bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, itemsBytes[i].length);
            mem.putByteArray(offsetBytes += 4L, itemsBytes[i], 0, itemsBytes[i].length);
            offsetBytes += (long)itemsBytes[i].length;
        }
        return bytes;
    }

    public String[] deserializeFromMemory(Memory mem, int length) {
        String[] array = new String[length];
        long offsetBytes = 0L;
        for (int i = 0; i < length; ++i) {
            int strLength = mem.getInt(offsetBytes);
            byte[] bytes = new byte[strLength];
            mem.getByteArray(offsetBytes += 4L, bytes, 0, strLength);
            offsetBytes += (long)strLength;
            array[i] = new String(bytes, StandardCharsets.UTF_8);
        }
        return array;
    }

    @Override
    public byte getType() {
        return 2;
    }
}

