/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.frequencies;

import org.apache.pulsar.shade.com.yahoo.sketches.QuickSelect;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.Util;

class ReversePurgeLongHashMap {
    private static final double LOAD_FACTOR = 0.75;
    private static final int DRIFT_LIMIT = 1024;
    private int lgLength;
    private int loadThreshold;
    private long[] keys;
    private long[] values;
    private short[] states;
    private int numActive = 0;

    ReversePurgeLongHashMap(int mapSize) {
        this.lgLength = Util.toLog2(mapSize, "mapSize");
        this.loadThreshold = (int)((double)mapSize * 0.75);
        this.keys = new long[mapSize];
        this.values = new long[mapSize];
        this.states = new short[mapSize];
    }

    static ReversePurgeLongHashMap getInstance(String string) {
        String[] tokens = string.split(",");
        if (tokens.length < 2) {
            throw new SketchesArgumentException("String not long enough to specify length and capacity.");
        }
        int numActive = Integer.parseInt(tokens[0]);
        int length = Integer.parseInt(tokens[1]);
        ReversePurgeLongHashMap table = new ReversePurgeLongHashMap(length);
        int j = 2;
        for (int i = 0; i < numActive; ++i) {
            long key = Long.parseLong(tokens[j++]);
            long value = Long.parseLong(tokens[j++]);
            table.adjustOrPutValue(key, value);
        }
        return table;
    }

    String serializeToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d,%d,", this.numActive, this.keys.length));
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.states[i] == 0) continue;
            sb.append(String.format("%d,%d,", this.keys[i], this.values[i]));
        }
        return sb.toString();
    }

    boolean isActive(int probe) {
        return this.states[probe] > 0;
    }

    long get(long key) {
        int probe = this.hashProbe(key);
        if (this.states[probe] > 0) {
            assert (this.keys[probe] == key);
            return this.values[probe];
        }
        return 0L;
    }

    void adjustOrPutValue(long key, long adjustAmount) {
        int arrayMask = this.keys.length - 1;
        int probe = (int)org.apache.pulsar.shade.com.yahoo.sketches.frequencies.Util.hash(key) & arrayMask;
        int drift = 1;
        while (this.states[probe] != 0 && this.keys[probe] != key) {
            probe = probe + 1 & arrayMask;
            assert (++drift < 1024) : "drift: " + drift + " >= DRIFT_LIMIT";
        }
        if (this.states[probe] == 0) {
            assert (this.numActive <= this.loadThreshold) : "numActive: " + this.numActive + " > loadThreshold: " + this.loadThreshold;
            this.keys[probe] = key;
            this.values[probe] = adjustAmount;
            this.states[probe] = (short)drift;
            ++this.numActive;
        } else {
            assert (this.keys[probe] == key);
            int n = probe;
            this.values[n] = this.values[n] + adjustAmount;
        }
    }

    void keepOnlyPositiveCounts() {
        int firstProbe = this.keys.length - 1;
        while (this.states[firstProbe] > 0) {
            --firstProbe;
        }
        int probe = firstProbe;
        while (probe-- > 0) {
            if (this.states[probe] <= 0 || this.values[probe] > 0L) continue;
            this.hashDelete(probe);
            --this.numActive;
        }
        probe = this.keys.length;
        while (probe-- > firstProbe) {
            if (this.states[probe] <= 0 || this.values[probe] > 0L) continue;
            this.hashDelete(probe);
            --this.numActive;
        }
    }

    void adjustAllValuesBy(long adjustAmount) {
        int i = this.keys.length;
        while (i-- > 0) {
            int n = i;
            this.values[n] = this.values[n] + adjustAmount;
        }
    }

    long[] getActiveKeys() {
        if (this.numActive == 0) {
            return null;
        }
        long[] returnedKeys = new long[this.numActive];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isActive(i)) continue;
            returnedKeys[j] = this.keys[i];
            ++j;
        }
        assert (j == this.numActive) : "j: " + j + " != numActive: " + this.numActive;
        return returnedKeys;
    }

    long[] getActiveValues() {
        if (this.numActive == 0) {
            return null;
        }
        long[] returnedValues = new long[this.numActive];
        int j = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.isActive(i)) continue;
            returnedValues[j] = this.values[i];
            ++j;
        }
        assert (j == this.numActive);
        return returnedValues;
    }

    void resize(int newSize) {
        long[] oldKeys = this.keys;
        long[] oldValues = this.values;
        short[] oldStates = this.states;
        this.keys = new long[newSize];
        this.values = new long[newSize];
        this.states = new short[newSize];
        this.loadThreshold = (int)((double)newSize * 0.75);
        this.lgLength = Integer.numberOfTrailingZeros(newSize);
        this.numActive = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldStates[i] <= 0) continue;
            this.adjustOrPutValue(oldKeys[i], oldValues[i]);
        }
    }

    int getLength() {
        return this.keys.length;
    }

    int getLgLength() {
        return this.lgLength;
    }

    int getCapacity() {
        return this.loadThreshold;
    }

    int getNumActive() {
        return this.numActive;
    }

    public String toString() {
        String fmt = "  %12d:%11d%20d %d";
        String hfmt = "  %12s:%11s%20s %s";
        StringBuilder sb = new StringBuilder();
        sb.append("ReversePurgeLongHashMap:").append(Util.LS);
        sb.append(String.format(hfmt, "Index", "States", "Values", "Keys")).append(Util.LS);
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.states[i] <= 0) continue;
            sb.append(String.format(fmt, i, this.states[i], this.values[i], this.keys[i])).append(Util.LS);
        }
        return sb.toString();
    }

    static double getLoadFactor() {
        return 0.75;
    }

    long purge(int sampleSize) {
        int limit = Math.min(sampleSize, this.getNumActive());
        int numSamples = 0;
        int i = 0;
        long[] samples = new long[limit];
        while (numSamples < limit) {
            if (this.isActive(i)) {
                samples[numSamples] = this.values[i];
                ++numSamples;
            }
            ++i;
        }
        long val = QuickSelect.select(samples, 0, numSamples - 1, limit / 2);
        this.adjustAllValuesBy(-1L * val);
        this.keepOnlyPositiveCounts();
        return val;
    }

    private void hashDelete(int deleteProbe) {
        this.states[deleteProbe] = 0;
        int drift = 1;
        int arrayMask = this.keys.length - 1;
        int probe = deleteProbe + drift & arrayMask;
        while (this.states[probe] != 0) {
            if (this.states[probe] > drift) {
                this.keys[deleteProbe] = this.keys[probe];
                this.values[deleteProbe] = this.values[probe];
                this.states[deleteProbe] = (short)(this.states[probe] - drift);
                this.states[probe] = 0;
                drift = 0;
                deleteProbe = probe;
            }
            probe = probe + 1 & arrayMask;
            assert (++drift < 1024) : "drift: " + drift + " >= DRIFT_LIMIT";
        }
    }

    private int hashProbe(long key) {
        int arrayMask = this.keys.length - 1;
        int probe = (int)org.apache.pulsar.shade.com.yahoo.sketches.frequencies.Util.hash(key) & arrayMask;
        while (this.states[probe] > 0 && this.keys[probe] != key) {
            probe = probe + 1 & arrayMask;
        }
        return probe;
    }

    Iterator iterator() {
        return new Iterator(this.keys, this.values, this.states);
    }

    class Iterator {
        private final long[] iKeys;
        private final long[] iValues;
        private final short[] iStates;
        private int i;

        Iterator(long[] keys, long[] values, short[] states) {
            this.iKeys = keys;
            this.iValues = values;
            this.iStates = states;
            this.i = -1;
        }

        boolean next() {
            ++this.i;
            while (this.i < this.iKeys.length) {
                if (this.iStates[this.i] > 0) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        long getKey() {
            return this.iKeys[this.i];
        }

        long getValue() {
            return this.iValues[this.i];
        }
    }
}

