/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.memory;

import org.apache.pulsar.shade.com.yahoo.sketches.memory.MemoryRequest;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.UnsafeUtil;

public class AllocMemory
extends NativeMemory {
    public AllocMemory(long capacityBytes) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.allocateMemory(capacityBytes);
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = null;
    }

    public AllocMemory(long capacityBytes, MemoryRequest memReq) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.allocateMemory(capacityBytes);
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = memReq;
    }

    public AllocMemory(NativeMemory origMem, long newCapacityBytes, MemoryRequest memReq) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.reallocateMemory(origMem.nativeRawStartAddress_, newCapacityBytes);
        this.capacityBytes_ = newCapacityBytes;
        this.memReq_ = memReq;
        origMem.nativeRawStartAddress_ = 0L;
        origMem.capacityBytes_ = 0L;
    }

    public AllocMemory(NativeMemory origMem, long copyToBytes, long capacityBytes, MemoryRequest memReq) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.allocateMemory(capacityBytes);
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = memReq;
        NativeMemory.copy(origMem, 0L, this, 0L, copyToBytes);
        this.clear(copyToBytes, capacityBytes - copyToBytes);
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
    }

    protected void finalize() {
        if (this.requiresFree()) {
            System.err.println("ERROR: freeMemory() has not been called: Address: " + this.nativeRawStartAddress_ + ", capacity: " + this.capacityBytes_);
            StackTraceElement[] arr = Thread.currentThread().getStackTrace();
            for (int i = 0; i < arr.length; ++i) {
                System.err.println(arr[i].toString());
            }
        }
    }
}

