/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.memory;

import java.lang.reflect.Constructor;
import sun.misc.Unsafe;

final class UnsafeUtil {
    static final Unsafe unsafe;
    static final int ADDRESS_SIZE;
    static final int ARRAY_BOOLEAN_BASE_OFFSET;
    static final int ARRAY_BYTE_BASE_OFFSET;
    static final int ARRAY_SHORT_BASE_OFFSET;
    static final int ARRAY_CHAR_BASE_OFFSET;
    static final int ARRAY_INT_BASE_OFFSET;
    static final int ARRAY_LONG_BASE_OFFSET;
    static final int ARRAY_FLOAT_BASE_OFFSET;
    static final int ARRAY_DOUBLE_BASE_OFFSET;
    static final int ARRAY_OBJECT_BASE_OFFSET;
    static final int ARRAY_BOOLEAN_INDEX_SCALE;
    static final int ARRAY_BYTE_INDEX_SCALE;
    static final int ARRAY_SHORT_INDEX_SCALE;
    static final int ARRAY_CHAR_INDEX_SCALE;
    static final int ARRAY_INT_INDEX_SCALE;
    static final int ARRAY_LONG_INDEX_SCALE;
    static final int ARRAY_FLOAT_INDEX_SCALE;
    static final int ARRAY_DOUBLE_INDEX_SCALE;
    static final int ARRAY_OBJECT_INDEX_SCALE;
    static final int BOOLEAN_SHIFT = 0;
    static final int BYTE_SHIFT = 0;
    static final int SHORT_SHIFT = 1;
    static final int CHAR_SHIFT = 1;
    static final int INT_SHIFT = 2;
    static final int LONG_SHIFT = 3;
    static final int FLOAT_SHIFT = 2;
    static final int DOUBLE_SHIFT = 3;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeUtil() {
    }

    static void assertBounds(long reqOff, long reqLen, long allocSize) {
        assert ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) >= 0L) : "offset: " + reqOff + ", reqLength: " + reqLen + ", size: " + allocSize;
    }

    static boolean checkOverlap(long srcOff, long dstOff, long length) {
        long max;
        long min = Math.min(srcOff, dstOff);
        return min + length <= (max = Math.max(srcOff, dstOff));
    }

    static {
        try {
            Constructor unsafeConstructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
            unsafeConstructor.setAccessible(true);
            unsafe = (Unsafe)unsafeConstructor.newInstance(new Object[0]);
            ADDRESS_SIZE = unsafe.addressSize();
            ARRAY_BOOLEAN_BASE_OFFSET = unsafe.arrayBaseOffset(boolean[].class);
            ARRAY_BYTE_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
            ARRAY_SHORT_BASE_OFFSET = unsafe.arrayBaseOffset(short[].class);
            ARRAY_CHAR_BASE_OFFSET = unsafe.arrayBaseOffset(char[].class);
            ARRAY_INT_BASE_OFFSET = unsafe.arrayBaseOffset(int[].class);
            ARRAY_LONG_BASE_OFFSET = unsafe.arrayBaseOffset(long[].class);
            ARRAY_FLOAT_BASE_OFFSET = unsafe.arrayBaseOffset(float[].class);
            ARRAY_DOUBLE_BASE_OFFSET = unsafe.arrayBaseOffset(double[].class);
            ARRAY_OBJECT_BASE_OFFSET = unsafe.arrayBaseOffset(Object[].class);
            ARRAY_BOOLEAN_INDEX_SCALE = unsafe.arrayIndexScale(boolean[].class);
            ARRAY_BYTE_INDEX_SCALE = unsafe.arrayIndexScale(byte[].class);
            ARRAY_SHORT_INDEX_SCALE = unsafe.arrayIndexScale(short[].class);
            ARRAY_CHAR_INDEX_SCALE = unsafe.arrayIndexScale(char[].class);
            ARRAY_INT_INDEX_SCALE = unsafe.arrayIndexScale(int[].class);
            ARRAY_LONG_INDEX_SCALE = unsafe.arrayIndexScale(long[].class);
            ARRAY_FLOAT_INDEX_SCALE = unsafe.arrayIndexScale(float[].class);
            ARRAY_DOUBLE_INDEX_SCALE = unsafe.arrayIndexScale(double[].class);
            ARRAY_OBJECT_INDEX_SCALE = unsafe.arrayIndexScale(Object[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to acquire Unsafe. ", e);
        }
    }
}

