/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesAuxiliary;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.PreambleUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

class HeapDoublesSketch
extends DoublesSketch {
    static final byte SKETCH_TYPE = 1;
    double minValue_;
    double maxValue_;
    int combinedBufferItemCapacity_;
    int baseBufferCount_;
    long bitPattern_;
    double[] combinedBuffer_;

    private HeapDoublesSketch(int k) {
        super(k);
    }

    static HeapDoublesSketch getInstance(int k) {
        HeapDoublesSketch hqs = new HeapDoublesSketch(k);
        int bufAlloc = Math.min(4, 2 * k);
        hqs.n_ = 0L;
        hqs.combinedBufferItemCapacity_ = bufAlloc;
        hqs.combinedBuffer_ = new double[bufAlloc];
        hqs.baseBufferCount_ = 0;
        hqs.bitPattern_ = 0L;
        hqs.minValue_ = Double.POSITIVE_INFINITY;
        hqs.maxValue_ = Double.NEGATIVE_INFINITY;
        return hqs;
    }

    static HeapDoublesSketch getInstance(Memory srcMem) {
        long bits;
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Memory too small: " + memCapBytes);
        }
        long pre0 = srcMem.getLong(0L);
        int preambleLongs = PreambleUtil.extractPreLongs(pre0);
        int serVer = PreambleUtil.extractSerVer(pre0);
        int familyID = PreambleUtil.extractFamilyID(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        int k = PreambleUtil.extractK(pre0);
        byte type = PreambleUtil.extractSketchType(pre0);
        if (type != 1) {
            throw new SketchesArgumentException("Possible Corruption: Sketch Type incorrect: " + type + " != " + 1);
        }
        boolean empty = Util.checkPreLongsFlagsCap(preambleLongs, flags, memCapBytes);
        Util.checkFamilyID(familyID);
        Util.checkSerVer(serVer);
        HeapDoublesSketch hqs = HeapDoublesSketch.getInstance(k);
        if (empty) {
            return hqs;
        }
        long n = srcMem.getLong(8L);
        int retainedItems = Util.computeRetainedItems(k, n);
        Util.checkMemCapacity(retainedItems, memCapBytes);
        hqs.n_ = n;
        hqs.combinedBufferItemCapacity_ = Util.computeCombBufItemCapacity(k, n);
        hqs.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        hqs.bitPattern_ = Util.computeBitPattern(k, n);
        hqs.combinedBuffer_ = new double[hqs.combinedBufferItemCapacity_];
        int srcMemItemsOffsetBytes = preambleLongs * 8;
        hqs.minValue_ = srcMem.getDouble(srcMemItemsOffsetBytes);
        hqs.maxValue_ = srcMem.getDouble(srcMemItemsOffsetBytes += 8);
        srcMem.getDoubleArray(srcMemItemsOffsetBytes += 8, hqs.combinedBuffer_, 0, hqs.baseBufferCount_);
        srcMemItemsOffsetBytes += hqs.baseBufferCount_ * 8;
        if (bits == 0L) {
            return hqs;
        }
        int levelBytes = k * 8;
        int level = 0;
        for (bits = Util.computeBitPattern(k, n); bits != 0L; bits >>>= 1) {
            if ((bits & 1L) > 0L) {
                srcMem.getDoubleArray(srcMemItemsOffsetBytes, hqs.combinedBuffer_, (2 + level) * k, k);
                srcMemItemsOffsetBytes += levelBytes;
            }
            ++level;
        }
        return hqs;
    }

    static HeapDoublesSketch copy(DoublesSketch sketch) {
        HeapDoublesSketch qsCopy = HeapDoublesSketch.getInstance(sketch.getK());
        qsCopy.n_ = sketch.getN();
        qsCopy.minValue_ = sketch.getMinValue();
        qsCopy.maxValue_ = sketch.getMaxValue();
        qsCopy.combinedBufferItemCapacity_ = sketch.getCombinedBufferItemCapacity();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        double[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    @Override
    public void update(double dataItem) {
        if (Double.isNaN(dataItem)) {
            return;
        }
        if (dataItem > this.maxValue_) {
            this.maxValue_ = dataItem;
        }
        if (dataItem < this.minValue_) {
            this.minValue_ = dataItem;
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferItemCapacity_) {
            DoublesUtil.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = dataItem;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            DoublesUtil.processFullBaseBuffer(this);
        }
    }

    @Override
    public double getQuantile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.minValue_;
        }
        if (fraction == 1.0) {
            return this.maxValue_;
        }
        DoublesAuxiliary aux = this.constructAuxiliary();
        return aux.getQuantile(fraction);
    }

    @Override
    public double[] getQuantiles(double[] fractions) {
        Util.validateFractions(fractions);
        DoublesAuxiliary aux = null;
        double[] answers = new double[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            double fraction = fractions[i];
            if (fraction == 0.0) {
                answers[i] = this.minValue_;
                continue;
            }
            if (fraction == 1.0) {
                answers[i] = this.maxValue_;
                continue;
            }
            if (aux == null) {
                aux = this.constructAuxiliary();
            }
            answers[i] = aux.getQuantile(fraction);
        }
        return answers;
    }

    @Override
    public double[] getPMF(double[] splitPoints) {
        long[] counters = DoublesUtil.internalBuildHistogram(splitPoints, this);
        int numCounters = counters.length;
        double[] result = new double[numCounters];
        double n = this.n_;
        long subtotal = 0L;
        for (int j = 0; j < numCounters; ++j) {
            long count = counters[j];
            subtotal += count;
            result[j] = (double)count / n;
        }
        assert ((double)subtotal == n);
        return result;
    }

    @Override
    public double[] getCDF(double[] splitPoints) {
        long[] counters = DoublesUtil.internalBuildHistogram(splitPoints, this);
        int numCounters = counters.length;
        double[] result = new double[numCounters];
        double n = this.n_;
        long subtotal = 0L;
        for (int j = 0; j < numCounters; ++j) {
            long count = counters[j];
            result[j] = (double)(subtotal += count) / n;
        }
        assert ((double)subtotal == n);
        return result;
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public double getMinValue() {
        return this.minValue_;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue_;
    }

    @Override
    public void reset() {
        this.n_ = 0L;
        this.combinedBufferItemCapacity_ = Math.min(4, 2 * this.k_);
        this.combinedBuffer_ = new double[this.combinedBufferItemCapacity_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minValue_ = Double.POSITIVE_INFINITY;
        this.maxValue_ = Double.NEGATIVE_INFINITY;
    }

    @Override
    public byte[] toByteArray() {
        int flags;
        int arrLongs;
        int preLongs;
        boolean empty = this.isEmpty();
        if (empty) {
            preLongs = 1;
            arrLongs = 1;
            flags = 4;
        } else {
            preLongs = 2;
            arrLongs = preLongs + 2 + Util.computeRetainedItems(this.k_, this.n_);
            flags = 0;
        }
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertSerVer(2, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.QUANTILES.getID(), pre0);
        pre0 = PreambleUtil.insertFlags(flags, pre0);
        pre0 = PreambleUtil.insertK(this.k_, pre0);
        pre0 = PreambleUtil.insertSketchType((byte)1, pre0);
        byte[] outArr = new byte[arrLongs << 3];
        NativeMemory memOut = new NativeMemory(outArr);
        if (empty) {
            memOut.putLong(0L, pre0);
            return outArr;
        }
        memOut.putLong(0L, pre0);
        memOut.putLong(8L, this.n_);
        memOut.putDouble(16L, this.minValue_);
        memOut.putDouble(24L, this.maxValue_);
        int bbItems = Util.computeBaseBufferItems(this.k_, this.n_);
        int offsetBytes = preLongs + 2 << 3;
        if (bbItems < 2 * this.k_ && bbItems > 0) {
            memOut.putDoubleArray(offsetBytes, this.combinedBuffer_, 0, bbItems);
            offsetBytes += 8 * bbItems;
        }
        int level = 0;
        for (long bits = Util.computeBitPattern(this.k_, this.n_); bits != 0L; bits >>>= 1) {
            if ((bits & 1L) > 0L) {
                memOut.putDoubleArray(offsetBytes, this.combinedBuffer_, (2 + level) * this.k_, this.k_);
                offsetBytes += this.k_ * 8;
            }
            ++level;
        }
        return outArr;
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        return DoublesUtil.toString(sketchSummary, dataDetail, this);
    }

    @Override
    public DoublesSketch downSample(int newK) {
        HeapDoublesSketch oldSketch = this;
        HeapDoublesSketch newSketch = HeapDoublesSketch.getInstance(newK);
        DoublesUtil.downSamplingMergeInto(oldSketch, newSketch);
        return newSketch;
    }

    @Override
    public void putMemory(Memory dstMem) {
        byte[] byteArr = this.toByteArray();
        int arrLen = byteArr.length;
        long memCap = dstMem.getCapacity();
        if (memCap < (long)arrLen) {
            throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
        }
        dstMem.putByteArray(0L, byteArr, 0, arrLen);
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return this.combinedBufferItemCapacity_;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    DoublesAuxiliary constructAuxiliary() {
        return new DoublesAuxiliary(this);
    }
}

