/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUnion;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;

class HeapDoublesUnion
extends DoublesUnion {
    private final int k_;
    private HeapDoublesSketch gadget_;

    HeapDoublesUnion(int k) {
        this.k_ = k;
    }

    HeapDoublesUnion(DoublesSketch sketch) {
        this.k_ = sketch.getK();
        this.gadget_ = (HeapDoublesSketch)sketch;
    }

    HeapDoublesUnion(Memory srcMem) {
        this.gadget_ = HeapDoublesSketch.getInstance(srcMem);
        this.k_ = this.gadget_.getK();
    }

    @Override
    public void update(DoublesSketch sketchIn) {
        this.gadget_ = HeapDoublesUnion.updateLogic(this.gadget_, (HeapDoublesSketch)sketchIn);
    }

    @Override
    public void update(Memory srcMem) {
        HeapDoublesSketch that = HeapDoublesSketch.getInstance(srcMem);
        this.gadget_ = HeapDoublesUnion.updateLogic(this.gadget_, that);
    }

    @Override
    public void update(double dataItem) {
        if (this.gadget_ == null) {
            this.gadget_ = HeapDoublesSketch.getInstance(this.k_);
        }
        this.gadget_.update(dataItem);
    }

    @Override
    public DoublesSketch getResult() {
        if (this.gadget_ == null) {
            return HeapDoublesSketch.getInstance(this.k_);
        }
        return HeapDoublesSketch.copy(this.gadget_);
    }

    @Override
    public DoublesSketch getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        HeapDoublesSketch hqs = this.gadget_;
        this.gadget_ = null;
        return hqs;
    }

    @Override
    public void reset() {
        this.gadget_ = null;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        if (this.gadget_ == null) {
            return HeapDoublesSketch.getInstance(this.k_).toString();
        }
        return this.gadget_.toString(sketchSummary, dataDetail);
    }

    static HeapDoublesSketch updateLogic(HeapDoublesSketch myQS, HeapDoublesSketch other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 2;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
            }
        }
        switch (outCase) {
            case 0: {
                return null;
            }
            case 1: {
                return myQS;
            }
            case 2: {
                return HeapDoublesSketch.copy(other);
            }
        }
        if (myQS.getK() <= other.getK()) {
            HeapDoublesUnion.mergeInto(other, myQS);
            return myQS;
        }
        HeapDoublesSketch myNewQS = HeapDoublesSketch.copy(other);
        HeapDoublesUnion.mergeInto(myQS, myNewQS);
        return myNewQS;
    }

    static void mergeInto(DoublesSketch source, DoublesSketch target) {
        long srcBitPattern;
        double[] srcLevels;
        HeapDoublesSketch src = (HeapDoublesSketch)source;
        HeapDoublesSketch tgt = (HeapDoublesSketch)target;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long srcN = src.getN();
        long tgtN = tgt.getN();
        if (srcK != tgtK) {
            DoublesUtil.downSamplingMergeInto(src, tgt);
            return;
        }
        double[] srcBaseBuffer = srcLevels = src.getCombinedBuffer();
        long nFinal = tgtN + srcN;
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(srcBaseBuffer[i]);
        }
        DoublesUtil.maybeGrowLevels(nFinal, tgt);
        double[] scratchBuf = new double[2 * tgtK];
        assert (srcBitPattern == srcN / (2L * (long)srcK));
        int srcLvl = 0;
        for (srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                DoublesUtil.inPlacePropagateCarry(srcLvl, srcLevels, (2 + srcLvl) * tgtK, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (long)(2 * tgtK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        if (srcMax > tgtMax) {
            tgt.maxValue_ = srcMax;
        }
        if (srcMin < tgtMin) {
            tgt.minValue_ = srcMin;
        }
    }
}

