/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.theta;

import org.apache.pulsar.shade.com.yahoo.sketches.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.CompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.DirectCompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.PreambleUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.UpdateSketch;

class DirectCompactOrderedSketch
extends CompactSketch {
    private Memory mem_;
    private int preLongs_;

    private DirectCompactOrderedSketch(boolean empty, short seedHash, int curCount, long thetaLong) {
        super(empty, seedHash, curCount, thetaLong);
    }

    static DirectCompactOrderedSketch wrapInstance(Memory srcMem, long pre0) {
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        boolean empty = (flags & 4) > 0;
        short seedHash = (short)PreambleUtil.extractSeedHash(pre0);
        int curCount = preLongs > 1 ? srcMem.getInt(8L) : 0;
        long thetaLong = preLongs > 2 ? srcMem.getLong(16L) : Long.MAX_VALUE;
        DirectCompactOrderedSketch dcos = new DirectCompactOrderedSketch(empty, seedHash, curCount, thetaLong);
        dcos.preLongs_ = preLongs;
        dcos.mem_ = srcMem;
        return dcos;
    }

    DirectCompactOrderedSketch(UpdateSketch sketch, Memory dstMem) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        boolean ordered = true;
        long[] compactOrderedCache = CompactSketch.compactCache(sketch.getCache(), this.getRetainedEntries(false), this.getThetaLong(), ordered);
        this.mem_ = DirectCompactOrderedSketch.loadCompactMemory(compactOrderedCache, this.isEmpty(), this.getSeedHash(), this.getRetainedEntries(false), this.getThetaLong(), dstMem, flags);
        this.preLongs_ = this.mem_.getByte(0L) & 0x3F;
    }

    DirectCompactOrderedSketch(long[] compactOrderedCache, boolean empty, short seedHash, int curCount, long thetaLong, Memory dstMem) {
        super(empty, seedHash, curCount, thetaLong);
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        this.mem_ = DirectCompactOrderedSketch.loadCompactMemory(compactOrderedCache, empty, seedHash, curCount, thetaLong, dstMem, flags);
    }

    @Override
    public byte[] toByteArray() {
        return DirectCompactSketch.compactMemoryToByteArray(this.mem_, this.getRetainedEntries(false));
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    long[] getCache() {
        long[] cache = new long[this.getRetainedEntries(false)];
        this.mem_.getLongArray(this.preLongs_ << 3, cache, 0, this.getRetainedEntries(false));
        return cache;
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

