/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.tuple;

import org.apache.pulsar.shade.com.yahoo.sketches.tuple.CompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.QuickSelectSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.Sketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.SketchIterator;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.Summary;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.SummaryFactory;

public class Union<S extends Summary> {
    private final int nomEntries_;
    private final SummaryFactory<S> summaryFactory_;
    private QuickSelectSketch<S> sketch_;
    private long theta_;

    public Union(int nomEntries, SummaryFactory<S> summaryFactory) {
        this.nomEntries_ = nomEntries;
        this.summaryFactory_ = summaryFactory;
        this.sketch_ = new QuickSelectSketch<S>(nomEntries, summaryFactory);
        this.theta_ = this.sketch_.getThetaLong();
    }

    public void update(Sketch<S> sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        if (sketchIn.theta_ < this.theta_) {
            this.theta_ = sketchIn.theta_;
        }
        SketchIterator<S> it = sketchIn.iterator();
        while (it.next()) {
            this.sketch_.merge(it.getKey(), it.getSummary());
        }
    }

    public CompactSketch<S> getResult() {
        this.sketch_.trim();
        if (this.theta_ < this.sketch_.theta_) {
            this.sketch_.setThetaLong(this.theta_);
            this.sketch_.rebuild();
        }
        return this.sketch_.compact();
    }

    public void reset() {
        this.sketch_ = new QuickSelectSketch<S>(this.nomEntries_, this.summaryFactory_);
    }
}

