/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.naming;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.base.Splitter;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.DestinationDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationName
implements ServiceUnitId {
    private static final Logger log = LoggerFactory.getLogger(DestinationName.class);
    private static final String PARTITIONED_TOPIC_SUFFIX = "-partition-";
    private final String destination;
    private final DestinationDomain domain;
    private final String property;
    private final String cluster;
    private final String namespacePortion;
    private final String localName;
    private final NamespaceName namespaceName;
    private final int partitionIndex;
    private static final LoadingCache<String, DestinationName> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<String, DestinationName>(){

        @Override
        public DestinationName load(String name) throws Exception {
            return new DestinationName(name);
        }
    });

    public static DestinationName get(String domain, String property, String cluster, String namespace, String destination) {
        String name = domain + "://" + property + '/' + cluster + '/' + namespace + '/' + destination;
        return DestinationName.get(name);
    }

    public static DestinationName get(String destination) {
        try {
            return cache.get(destination);
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static boolean isValid(String destination) {
        try {
            DestinationName.get(destination);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private DestinationName(String destination) {
        this.destination = destination;
        try {
            if (!destination.contains("://")) {
                throw new IllegalArgumentException("Invalid destination name: " + destination + " -- Domain is missing");
            }
            List<String> parts = Splitter.on("://").limit(2).splitToList(destination);
            this.domain = DestinationDomain.getEnum(parts.get(0));
            String rest = parts.get(1);
            parts = Splitter.on("/").limit(4).splitToList(rest);
            if (parts.size() != 4) {
                throw new IllegalArgumentException("Invalid destination name: " + destination);
            }
            this.property = parts.get(0);
            this.cluster = parts.get(1);
            this.namespacePortion = parts.get(2);
            this.localName = parts.get(3);
            this.partitionIndex = DestinationName.getPartitionIndex(destination);
            NamespaceName.validateNamespaceName(this.property, this.cluster, this.namespacePortion);
            if (Preconditions.checkNotNull(this.localName).isEmpty()) {
                throw new IllegalArgumentException("Invalid destination name: " + destination);
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid destination name: " + destination, e);
        }
        this.namespaceName = NamespaceName.get(this.property, this.cluster, this.namespacePortion);
    }

    public String getNamespace() {
        return this.namespaceName.toString();
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this.namespaceName;
    }

    public DestinationDomain getDomain() {
        return this.domain;
    }

    public String getProperty() {
        return this.property;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getNamespacePortion() {
        return this.namespacePortion;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getEncodedLocalName() {
        return Codec.encode(this.localName);
    }

    public DestinationName getPartition(int index) {
        if (index == -1 || this.toString().contains(PARTITIONED_TOPIC_SUFFIX)) {
            return this;
        }
        String partitionName = this.toString() + PARTITIONED_TOPIC_SUFFIX + index;
        return DestinationName.get(partitionName);
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public boolean isPartitioned() {
        return this.partitionIndex != -1;
    }

    public String getPartitionedTopicName() {
        if (this.isPartitioned()) {
            return this.destination.substring(0, this.destination.lastIndexOf(PARTITIONED_TOPIC_SUFFIX));
        }
        return this.destination;
    }

    public static int getPartitionIndex(String topic) {
        int partitionIndex = -1;
        if (topic.contains(PARTITIONED_TOPIC_SUFFIX)) {
            try {
                partitionIndex = Integer.parseInt(topic.substring(topic.lastIndexOf(45) + 1));
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not get the partition index from the topic {}", (Object)topic);
            }
        }
        return partitionIndex;
    }

    public String getPersistenceNamingEncoding() {
        return String.format("%s/%s/%s/%s/%s", new Object[]{this.property, this.cluster, this.namespacePortion, this.domain, this.getEncodedLocalName()});
    }

    public String getLookupName() {
        return String.format("%s/%s/%s/%s/%s", new Object[]{this.domain, this.property, this.cluster, this.namespacePortion, this.getEncodedLocalName()});
    }

    public boolean isGlobal() {
        return "global".equals(this.cluster);
    }

    @Override
    public String toString() {
        return this.destination;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DestinationName) {
            DestinationName other = (DestinationName)obj;
            return Objects.equal(this.destination, other.destination);
        }
        return false;
    }

    public int hashCode() {
        return this.destination.hashCode();
    }

    @Override
    public boolean includes(DestinationName dn) {
        return this.equals(dn);
    }
}

