/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.naming;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedEntity {
    private static final Pattern NAMED_ENTITY_PATTERN = Pattern.compile("^[-=:.\\w]*$");

    public static void checkName(String name) throws IllegalArgumentException {
        Matcher m = NAMED_ENTITY_PATTERN.matcher(name);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid named entity: " + name);
        }
    }

    public static void checkURI(URI uri, String name) {
        if (!String.format("%s://%s%s", uri.getScheme(), uri.getHost(), uri.getPath()).equals(name)) {
            throw new IllegalArgumentException("Invalid trailing chars in named entity: " + name);
        }
    }
}

