/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.stats;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.collect.Maps;

public class Metrics {
    final Map<String, Object> metrics = Maps.newTreeMap();
    @JsonInclude(content=JsonInclude.Include.NON_EMPTY)
    final Map<String, String> dimensions;

    protected Metrics(Map<String, String> unmodifiableDimensionMap) {
        this.dimensions = unmodifiableDimensionMap;
    }

    public static Metrics create(Map<String, String> dimensionMap) {
        TreeMap<String, String> map = Maps.newTreeMap();
        map.putAll(dimensionMap);
        return new Metrics(Collections.unmodifiableMap(map));
    }

    public void put(String metricsName, Object value) {
        this.metrics.put(metricsName, value);
    }

    public Map<String, Object> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public void putAll(Map<String, Object> metrics) {
        this.metrics.putAll(metrics);
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public String getDimension(String dimensionName) {
        return this.dimensions.get(dimensionName);
    }

    public int hashCode() {
        return Objects.hashCode(this.dimensions);
    }

    public boolean equals(Object obj) {
        return obj instanceof Metrics && Objects.equal(this.dimensions, ((Metrics)obj).dimensions);
    }

    public String toString() {
        return String.format("dimensions=[%s], metrics=[%s]", this.dimensions, this.metrics);
    }
}

