/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pulsar.shade.io.netty.handler.ssl.ClientAuth;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContextBuilder;
import org.apache.pulsar.shade.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.KeyStoreHolder;

public class SecurityUtility {
    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertificates) throws GeneralSecurityException {
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertificates, (Certificate[])null, (PrivateKey)null);
    }

    public static SslContext createNettySslContextForClient(boolean allowInsecureConnection, String trustCertsFilePath) throws IOException, GeneralSecurityException, SSLException, FileNotFoundException {
        return SecurityUtility.createNettySslContextForClient(allowInsecureConnection, trustCertsFilePath, (Certificate[])null, (PrivateKey)null);
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath) throws GeneralSecurityException {
        Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile(trustCertsFilePath);
        Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertificates, certificates, privateKey);
    }

    public static SslContext createNettySslContextForClient(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath) throws IOException, GeneralSecurityException, SSLException, FileNotFoundException {
        Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        return SecurityUtility.createNettySslContextForClient(allowInsecureConnection, trustCertsFilePath, certificates, privateKey);
    }

    public static SslContext createNettySslContextForClient(boolean allowInsecureConnection, String trustCertsFilePath, Certificate[] certificates, PrivateKey privateKey) throws GeneralSecurityException, IOException, FileNotFoundException {
        SslContextBuilder builder = SslContextBuilder.forClient();
        if (allowInsecureConnection) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (trustCertsFilePath != null && trustCertsFilePath.length() != 0) {
            try (FileInputStream input = new FileInputStream(trustCertsFilePath);){
                builder.trustManager(input);
            }
        }
        builder.keyManager(privateKey, (X509Certificate[])certificates);
        return builder.build();
    }

    public static SslContext createNettySslContextForServer(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath) throws IOException, GeneralSecurityException, SSLException, FileNotFoundException {
        X509Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        SslContextBuilder builder = SslContextBuilder.forServer(privateKey, certificates);
        if (allowInsecureConnection) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (trustCertsFilePath != null && trustCertsFilePath.length() != 0) {
            try (FileInputStream input = new FileInputStream(trustCertsFilePath);){
                builder.trustManager(input);
            }
        } else {
            builder.trustManager((File)null);
        }
        builder.keyManager(privateKey, certificates);
        builder.clientAuth(ClientAuth.OPTIONAL);
        return builder.build();
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertficates, Certificate[] certificates, PrivateKey privateKey) throws GeneralSecurityException {
        KeyStoreHolder ksh = new KeyStoreHolder();
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        if (allowInsecureConnection) {
            trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
        } else {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (trustCertficates == null || trustCertficates.length == 0) {
                tmf.init((KeyStore)null);
            } else {
                for (int i = 0; i < trustCertficates.length; ++i) {
                    ksh.setCertificate("trust" + i, trustCertficates[i]);
                }
                tmf.init(ksh.getKeyStore());
            }
            trustManagers = tmf.getTrustManagers();
        }
        if (certificates != null && privateKey != null) {
            ksh.setPrivateKey("private", privateKey, certificates);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ksh.getKeyStore(), "".toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        SSLContext sslCtx = SSLContext.getInstance("TLS");
        sslCtx.init(keyManagers, trustManagers, new SecureRandom());
        return sslCtx;
    }

    public static X509Certificate[] loadCertificatesFromPemFile(String certFilePath) throws KeyManagementException {
        X509Certificate[] certificates = null;
        if (certFilePath == null || certFilePath.isEmpty()) {
            return certificates;
        }
        try (FileInputStream input = new FileInputStream(certFilePath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = cf.generateCertificates(input);
            certificates = collection.toArray(new X509Certificate[collection.size()]);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyManagementException("Certificate loading error", e);
        }
        return certificates;
    }

    public static PrivateKey loadPrivateKeyFromPemFile(String keyFilePath) throws KeyManagementException {
        PrivateKey privateKey = null;
        if (keyFilePath == null || keyFilePath.isEmpty()) {
            return privateKey;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(keyFilePath));){
            StringBuilder sb = new StringBuilder();
            String previousLine = "";
            String currentLine = null;
            reader.readLine();
            while ((currentLine = reader.readLine()) != null) {
                sb.append(previousLine);
                previousLine = currentLine;
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(sb.toString()));
            privateKey = kf.generatePrivate(keySpec);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyManagementException("Private key loading error", e);
        }
        return privateKey;
    }
}

