/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.exception.TooManyConnectionsException;
import org.apache.pulsar.shade.org.asynchttpclient.exception.TooManyConnectionsPerHostException;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.NonBlockingSemaphoreInfinite;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;
import org.apache.pulsar.shade.org.asynchttpclient.util.ThrowableUtil;

public class ConnectionSemaphore {
    private final int maxTotalConnections;
    private final NonBlockingSemaphoreLike freeChannels;
    private final int maxConnectionsPerHost;
    private final ConcurrentHashMap<Object, NonBlockingSemaphore> freeChannelsPerHost = new ConcurrentHashMap();
    private final IOException tooManyConnections;
    private final IOException tooManyConnectionsPerHost;

    public static ConnectionSemaphore newConnectionSemaphore(AsyncHttpClientConfig config) {
        return config.getMaxConnections() > 0 || config.getMaxConnectionsPerHost() > 0 ? new ConnectionSemaphore(config) : null;
    }

    private ConnectionSemaphore(AsyncHttpClientConfig config) {
        this.tooManyConnections = ThrowableUtil.unknownStackTrace(new TooManyConnectionsException(config.getMaxConnections()), ConnectionSemaphore.class, "acquireChannelLock");
        this.tooManyConnectionsPerHost = ThrowableUtil.unknownStackTrace(new TooManyConnectionsPerHostException(config.getMaxConnectionsPerHost()), ConnectionSemaphore.class, "acquireChannelLock");
        this.maxTotalConnections = config.getMaxConnections();
        this.maxConnectionsPerHost = config.getMaxConnectionsPerHost();
        this.freeChannels = this.maxTotalConnections > 0 ? new NonBlockingSemaphore(config.getMaxConnections()) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    private boolean tryAcquireGlobal() {
        return this.freeChannels.tryAcquire();
    }

    private NonBlockingSemaphoreLike getFreeConnectionsForHost(Object partitionKey) {
        return this.maxConnectionsPerHost > 0 ? (NonBlockingSemaphoreLike)this.freeChannelsPerHost.computeIfAbsent(partitionKey, pk -> new NonBlockingSemaphore(this.maxConnectionsPerHost)) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    private boolean tryAcquirePerHost(Object partitionKey) {
        return this.getFreeConnectionsForHost(partitionKey).tryAcquire();
    }

    public void acquireChannelLock(Object partitionKey) throws IOException {
        if (!this.tryAcquireGlobal()) {
            throw this.tooManyConnections;
        }
        if (!this.tryAcquirePerHost(partitionKey)) {
            this.freeChannels.release();
            throw this.tooManyConnectionsPerHost;
        }
    }

    public void releaseChannelLock(Object partitionKey) {
        this.freeChannels.release();
        this.getFreeConnectionsForHost(partitionKey).release();
    }
}

