/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.ReaderListener;

public class ReaderConfigurationData<T>
implements Serializable,
Cloneable {
    private String topicName;
    private MessageId startMessageId;
    private int receiverQueueSize = 1000;
    private ReaderListener<T> readerListener;
    private String readerName = null;
    private String subscriptionRolePrefix = null;
    private CryptoKeyReader cryptoKeyReader = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private boolean readCompacted = false;

    public ReaderConfigurationData<T> clone() {
        try {
            return (ReaderConfigurationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ReaderConfigurationData");
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public ReaderListener<T> getReaderListener() {
        return this.readerListener;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getSubscriptionRolePrefix() {
        return this.subscriptionRolePrefix;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setStartMessageId(MessageId startMessageId) {
        this.startMessageId = startMessageId;
    }

    public void setReceiverQueueSize(int receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public void setReaderListener(ReaderListener<T> readerListener) {
        this.readerListener = readerListener;
    }

    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    public void setSubscriptionRolePrefix(String subscriptionRolePrefix) {
        this.subscriptionRolePrefix = subscriptionRolePrefix;
    }

    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReaderConfigurationData)) {
            return false;
        }
        ReaderConfigurationData other = (ReaderConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        MessageId this$startMessageId = this.getStartMessageId();
        MessageId other$startMessageId = other.getStartMessageId();
        if (this$startMessageId == null ? other$startMessageId != null : !this$startMessageId.equals(other$startMessageId)) {
            return false;
        }
        if (this.getReceiverQueueSize() != other.getReceiverQueueSize()) {
            return false;
        }
        ReaderListener<T> this$readerListener = this.getReaderListener();
        ReaderListener<T> other$readerListener = other.getReaderListener();
        if (this$readerListener == null ? other$readerListener != null : !this$readerListener.equals(other$readerListener)) {
            return false;
        }
        String this$readerName = this.getReaderName();
        String other$readerName = other.getReaderName();
        if (this$readerName == null ? other$readerName != null : !this$readerName.equals(other$readerName)) {
            return false;
        }
        String this$subscriptionRolePrefix = this.getSubscriptionRolePrefix();
        String other$subscriptionRolePrefix = other.getSubscriptionRolePrefix();
        if (this$subscriptionRolePrefix == null ? other$subscriptionRolePrefix != null : !this$subscriptionRolePrefix.equals(other$subscriptionRolePrefix)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        ConsumerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ConsumerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !((Object)((Object)this$cryptoFailureAction)).equals((Object)other$cryptoFailureAction)) {
            return false;
        }
        return this.isReadCompacted() == other.isReadCompacted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReaderConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        MessageId $startMessageId = this.getStartMessageId();
        result = result * 59 + ($startMessageId == null ? 43 : $startMessageId.hashCode());
        result = result * 59 + this.getReceiverQueueSize();
        ReaderListener<T> $readerListener = this.getReaderListener();
        result = result * 59 + ($readerListener == null ? 43 : $readerListener.hashCode());
        String $readerName = this.getReaderName();
        result = result * 59 + ($readerName == null ? 43 : $readerName.hashCode());
        String $subscriptionRolePrefix = this.getSubscriptionRolePrefix();
        result = result * 59 + ($subscriptionRolePrefix == null ? 43 : $subscriptionRolePrefix.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        ConsumerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : ((Object)((Object)$cryptoFailureAction)).hashCode());
        result = result * 59 + (this.isReadCompacted() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ReaderConfigurationData(topicName=" + this.getTopicName() + ", startMessageId=" + this.getStartMessageId() + ", receiverQueueSize=" + this.getReceiverQueueSize() + ", readerListener=" + this.getReaderListener() + ", readerName=" + this.getReaderName() + ", subscriptionRolePrefix=" + this.getSubscriptionRolePrefix() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", cryptoFailureAction=" + (Object)((Object)this.getCryptoFailureAction()) + ", readCompacted=" + this.isReadCompacted() + ")";
    }
}

