/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class JSONSchema<T>
implements Schema<T> {
    private final SchemaInfo info;
    private final ObjectMapper objectMapper;
    private final Class<T> pojo;

    private JSONSchema(SchemaInfo info, Class<T> pojo, ObjectMapper objectMapper) {
        this.info = info;
        this.pojo = pojo;
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] encode(T message) throws SchemaSerializationException {
        try {
            return this.objectMapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            return this.objectMapper.readValue(new String(bytes), this.pojo);
        }
        catch (IOException e) {
            throw new RuntimeException(new SchemaSerializationException(e));
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.info;
    }

    public static <T> JSONSchema<T> of(Class<T> pojo) throws JsonProcessingException {
        return JSONSchema.of(pojo, Collections.emptyMap());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo, Map<String, String> properties) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
        JsonSchema schema = schemaGen.generateSchema(pojo);
        SchemaInfo info = new SchemaInfo();
        info.setName("");
        info.setProperties(properties);
        info.setType(SchemaType.JSON);
        info.setSchema(mapper.writeValueAsBytes(schema));
        return new JSONSchema<T>(info, pojo, mapper);
    }
}

