/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.netty.resolver.dns;

import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.pulsar.shade.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.pulsar.shade.io.netty.resolver.dns.SequentialDnsServerAddressStream;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;

final class ShuffledDnsServerAddressStream
implements DnsServerAddressStream {
    private final InetSocketAddress[] addresses;
    private int i;

    ShuffledDnsServerAddressStream(InetSocketAddress[] addresses) {
        this.addresses = addresses;
        this.shuffle();
    }

    private ShuffledDnsServerAddressStream(InetSocketAddress[] addresses, int startIdx) {
        this.addresses = addresses;
        this.i = startIdx;
    }

    private void shuffle() {
        InetSocketAddress[] addresses = this.addresses;
        Random r = PlatformDependent.threadLocalRandom();
        for (int i = addresses.length - 1; i >= 0; --i) {
            InetSocketAddress tmp = addresses[i];
            int j = r.nextInt(i + 1);
            addresses[i] = addresses[j];
            addresses[j] = tmp;
        }
    }

    @Override
    public InetSocketAddress next() {
        int i = this.i;
        InetSocketAddress next = this.addresses[i];
        if (++i < this.addresses.length) {
            this.i = i;
        } else {
            this.i = 0;
            this.shuffle();
        }
        return next;
    }

    @Override
    public int size() {
        return this.addresses.length;
    }

    @Override
    public ShuffledDnsServerAddressStream duplicate() {
        return new ShuffledDnsServerAddressStream(this.addresses, this.i);
    }

    public String toString() {
        return SequentialDnsServerAddressStream.toString("shuffled", this.i, this.addresses);
    }
}

