/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodec;

public class CompressionCodecZLib
implements CompressionCodec {
    private final Deflater deflater = new Deflater();
    private final Inflater inflater = new Inflater();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBuf source) {
        byte[] array;
        int length = source.readableBytes();
        int sizeEstimate = (int)Math.ceil((double)source.readableBytes() * 1.001) + 14;
        ByteBuf compressed = PooledByteBufAllocator.DEFAULT.heapBuffer(sizeEstimate);
        int offset = 0;
        if (source.hasArray()) {
            array = source.array();
            offset = source.arrayOffset() + source.readerIndex();
        } else {
            array = new byte[length];
            source.getBytes(source.readerIndex(), array);
        }
        Deflater deflater = this.deflater;
        synchronized (deflater) {
            this.deflater.setInput(array, offset, length);
            while (!this.deflater.needsInput()) {
                this.deflate(compressed);
            }
            this.deflater.reset();
        }
        return compressed;
    }

    private void deflate(ByteBuf out) {
        int numBytes;
        do {
            int writerIndex = out.writerIndex();
            numBytes = this.deflater.deflate(out.array(), out.arrayOffset() + writerIndex, out.writableBytes(), 2);
            out.writerIndex(writerIndex + numBytes);
        } while (numBytes > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        int resultLength;
        int offset;
        byte[] array;
        ByteBuf uncompressed = PooledByteBufAllocator.DEFAULT.heapBuffer(uncompressedLength, uncompressedLength);
        int len = encoded.readableBytes();
        if (encoded.hasArray()) {
            array = encoded.array();
            offset = encoded.arrayOffset() + encoded.readerIndex();
        } else {
            array = new byte[len];
            encoded.getBytes(encoded.readerIndex(), array);
            offset = 0;
        }
        Inflater inflater = this.inflater;
        synchronized (inflater) {
            this.inflater.setInput(array, offset, len);
            try {
                resultLength = this.inflater.inflate(uncompressed.array(), uncompressed.arrayOffset(), uncompressedLength);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            this.inflater.reset();
        }
        Preconditions.checkArgument(resultLength == uncompressedLength);
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

