/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.Map;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class ConsumerStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public double msgRateRedeliver;
    public String consumerName;
    public int availablePermits;
    public int unackedMessages;
    public boolean blockedConsumerOnUnackedMsgs;
    private int addressOffset = -1;
    private int addressLength;
    private int connectedSinceOffset = -1;
    private int connectedSinceLength;
    private int clientVersionOffset = -1;
    private int clientVersionLength;
    public Map<String, String> metadata;
    private StringBuilder stringBuffer = new StringBuilder();

    public ConsumerStats add(ConsumerStats stats) {
        Preconditions.checkNotNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.availablePermits += stats.availablePermits;
        this.unackedMessages += stats.unackedMessages;
        this.blockedConsumerOnUnackedMsgs = stats.blockedConsumerOnUnackedMsgs;
        return this;
    }

    public String getAddress() {
        return this.addressOffset == -1 ? null : this.stringBuffer.substring(this.addressOffset, this.addressOffset + this.addressLength);
    }

    public void setAddress(String address) {
        if (address == null) {
            this.addressOffset = -1;
            return;
        }
        this.addressOffset = this.stringBuffer.length();
        this.addressLength = address.length();
        this.stringBuffer.append(address);
    }

    public String getConnectedSince() {
        return this.connectedSinceOffset == -1 ? null : this.stringBuffer.substring(this.connectedSinceOffset, this.connectedSinceOffset + this.connectedSinceLength);
    }

    public void setConnectedSince(String connectedSince) {
        if (connectedSince == null) {
            this.connectedSinceOffset = -1;
            return;
        }
        this.connectedSinceOffset = this.stringBuffer.length();
        this.connectedSinceLength = connectedSince.length();
        this.stringBuffer.append(connectedSince);
    }

    public String getClientVersion() {
        return this.clientVersionOffset == -1 ? null : this.stringBuffer.substring(this.clientVersionOffset, this.clientVersionOffset + this.clientVersionLength);
    }

    public void setClientVersion(String clientVersion) {
        if (clientVersion == null) {
            this.clientVersionOffset = -1;
            return;
        }
        this.clientVersionOffset = this.stringBuffer.length();
        this.clientVersionLength = clientVersion.length();
        this.stringBuffer.append(clientVersion);
    }
}

