/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class FutureUtil {
    public static <T> CompletableFuture<T> waitForAll(List<CompletableFuture<T>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture compositeFuture = new CompletableFuture();
        AtomicInteger count = new AtomicInteger(futures.size());
        AtomicReference exception = new AtomicReference();
        for (CompletableFuture<T> future : futures) {
            future.whenComplete((r, ex) -> {
                if (ex != null) {
                    exception.compareAndSet(null, ex);
                }
                if (count.decrementAndGet() == 0) {
                    if (exception.get() != null) {
                        compositeFuture.completeExceptionally((Throwable)exception.get());
                    } else {
                        compositeFuture.complete(null);
                    }
                }
            });
        }
        return compositeFuture;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }
}

