/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.Realm;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.ntlm.NtlmEngine;
import org.apache.pulsar.shade.org.asynchttpclient.proxy.ProxyServer;
import org.apache.pulsar.shade.org.asynchttpclient.spnego.SpnegoEngine;
import org.apache.pulsar.shade.org.asynchttpclient.spnego.SpnegoEngineException;
import org.apache.pulsar.shade.org.asynchttpclient.uri.Uri;
import org.apache.pulsar.shade.org.asynchttpclient.util.Base64;
import org.apache.pulsar.shade.org.asynchttpclient.util.HttpUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.StringUtils;

public final class AuthenticatorUtils {
    public static final String NEGOTIATE = "Negotiate";

    public static String getHeaderWithPrefix(List<String> authenticateHeaders, String prefix) {
        if (authenticateHeaders != null) {
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                return authenticateHeader;
            }
        }
        return null;
    }

    public static String computeBasicAuthentication(Realm realm) {
        return realm != null ? AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset()) : null;
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.encode(s.getBytes(charset));
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = HttpUtils.getNonEmptyPath(uri);
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    private static String computeDigestAuthentication(Realm realm) {
        String realmUri = AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", realmUri, true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static StringBuilder append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        return builder.append(", ");
    }

    public static String perConnectionProxyAuthorizationHeader(Request request, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    List<String> auth = request.getHeaders().getAll(HttpHeaderNames.PROXY_AUTHORIZATION);
                    if (AuthenticatorUtils.getHeaderWithPrefix(auth, "NTLM") != null) break;
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    proxyAuthorization = "NTLM " + msg;
                    break;
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perRequestProxyAuthorizationHeader(Request request, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyRealm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(proxyRealm.getNonce())) break;
                    proxyRealm = Dsl.realm(proxyRealm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(proxyRealm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)proxyRealm.getScheme()));
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perConnectionAuthorizationHeader(Request request, ProxyServer proxyServer, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : request.getUri().getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.instance().generateToken(host);
                        break;
                    }
                    catch (SpnegoEngineException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return authorizationHeader;
    }

    public static String perRequestAuthorizationHeader(Request request, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    realm = Dsl.realm(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }
}

