/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.crc;

import java.util.EnumSet;
import org.apache.pulsar.shade.com.scurrilous.circe.Hash;
import org.apache.pulsar.shade.com.scurrilous.circe.HashSupport;
import org.apache.pulsar.shade.com.scurrilous.circe.StatelessHash;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.JavaCrc32;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.NormalByteCrc;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.NormalIntCrc;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.NormalLongCrc;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.ReflectedIntCrc;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.ReflectedLongCrc;
import org.apache.pulsar.shade.com.scurrilous.circe.impl.AbstractHashProvider;
import org.apache.pulsar.shade.com.scurrilous.circe.params.CrcParameters;

public final class StandardCrcProvider
extends AbstractHashProvider<CrcParameters> {
    public StandardCrcProvider() {
        super(CrcParameters.class);
    }

    @Override
    protected EnumSet<HashSupport> querySupportTyped(CrcParameters params) {
        EnumSet<HashSupport> result = EnumSet.of(HashSupport.STATEFUL, HashSupport.INCREMENTAL, HashSupport.STATELESS_INCREMENTAL, HashSupport.LONG_SIZED);
        if (params.bitWidth() <= 32) {
            result.add(HashSupport.INT_SIZED);
        }
        if (params.equals(CrcParameters.CRC32)) {
            result.add(HashSupport.NATIVE);
        }
        return result;
    }

    @Override
    protected Hash get(CrcParameters params, EnumSet<HashSupport> required) {
        if (!required.contains((Object)HashSupport.STATELESS_INCREMENTAL) && params.equals(CrcParameters.CRC32)) {
            return new JavaCrc32();
        }
        if (required.contains((Object)HashSupport.NATIVE)) {
            throw new UnsupportedOperationException();
        }
        return this.getCacheable(params, required);
    }

    @Override
    protected StatelessHash createCacheable(CrcParameters params, EnumSet<HashSupport> required) {
        int bitWidth = params.bitWidth();
        if (bitWidth > 32 || required.contains((Object)HashSupport.LONG_SIZED) && bitWidth >= 8) {
            if (required.contains((Object)HashSupport.INT_SIZED)) {
                throw new UnsupportedOperationException();
            }
            if (params.reflected()) {
                return new ReflectedLongCrc(params.algorithm(), bitWidth, params.polynomial(), params.initial(), params.xorOut());
            }
            return new NormalLongCrc(params.algorithm(), bitWidth, params.polynomial(), params.initial(), params.xorOut());
        }
        if (params.reflected()) {
            return new ReflectedIntCrc(params.algorithm(), bitWidth, (int)params.polynomial(), (int)params.initial(), (int)params.xorOut());
        }
        if (bitWidth > 8) {
            return new NormalIntCrc(params.algorithm(), bitWidth, (int)params.polynomial(), (int)params.initial(), (int)params.xorOut());
        }
        return new NormalByteCrc(params.algorithm(), bitWidth, (int)params.polynomial(), (int)params.initial(), (int)params.xorOut());
    }
}

